import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/features/projects/model/gorevler.dart';

import '../../../core/constants/color_constants.dart';
import '../../auth/login/cubit/login_cubit.dart';
import '../cubit/missions_cubit.dart';

class TaskCard extends StatefulWidget {
  final Gorevler gorev;

  const TaskCard({super.key, required this.gorev});

  @override
  State<TaskCard> createState() => _TaskCardState();
}

class _TaskCardState extends State<TaskCard> {
  final String descriptionTxt = "Açıklama";

  @override
  Widget build(BuildContext context) {
    return Card(
      child: ExpansionTile(
        shape: const ContinuousRectangleBorder(
            borderRadius: BorderRadius.all(Radius.circular(10))),
        childrenPadding:
            EdgeInsets.all(_emptyExpansionTileHeightSpace(context)),
        leading: _checkbox(widget.gorev),
        iconColor: ColorsConstants.instance.baseTheme,
        title: Text(
          widget.gorev.gorevAd!,
          style:
              Theme.of(context).textTheme.displaySmall?.copyWith(fontSize: 14),
        ),
        children: [
          SizedBox(height: _emptyExpansionTileHeightTextSpace(context)),
          Row(children: [
            Text(descriptionTxt,
                style: Theme.of(context).textTheme.displayMedium?.copyWith(
                    fontSize: 14,
                    color:
                        ColorsConstants.instance.baseTheme.withOpacity(0.8))),
          ]),
          SizedBox(height: _emptyExpansionTileHeightTextSpace(context)),
          Text(
            widget.gorev.gorevAciklama!,
            style: Theme.of(context)
                .textTheme
                .titleSmall
                ?.copyWith(color: Colors.black54, fontSize: 11),
          ),
        ],
      ),
    );
  }

  double _emptyExpansionTileHeightTextSpace(BuildContext context) =>
      context.dynamicHeight(0.015);

  double _emptyExpansionTileHeightSpace(BuildContext context) =>
      context.dynamicHeight(0.03);

  Widget _checkbox(Gorevler gorev) {
    return Checkbox(
      shape: const CircleBorder(),
      checkColor: Colors.white,
      activeColor: Colors.green,
      splashRadius: 0.8,
      value: (gorev.gorevDurum == "1"),
      onChanged: (bool? value) {
        setState(() {
          if (value != null) {
            gorev.gorevDurum = value
                ? '1'
                : '0'; // Checkbox değerine göre görev onayı güncelleniyor
            if (gorev.gorevDurum == '1') {
              context.read<MissionsCubit>().ekGorevOnayla(
                  gorev.gorevId!,
                  "1",
                  context.read<LoginCubit>().token,
                  context.read<LoginCubit>().id,
                  gorev.gorevProjeId ??
                      ''); //tamamlandı ise 1 gönder check false ise 0 gönder
            } else {
              context.read<MissionsCubit>().ekGorevOnayla(
                  gorev.gorevId!,
                  "0",
                  context.read<LoginCubit>().token,
                  context.read<LoginCubit>().id,
                  gorev.gorevProjeId ?? '');
            }
          }
        });
      },
    );
  }
}
