import 'package:flutter/material.dart';
import '../../../../../core/constants/color_constants.dart';

class CustomAutoCompleteInputDecoration extends InputDecoration {
  CustomAutoCompleteInputDecoration(String hintTxt, IconData icon)
      : super(
          enabledBorder: OutlineInputBorder(
            borderRadius: BorderRadius.circular(8),
            borderSide: BorderSide(color: Colors.grey.shade400),
          ),
          focusedBorder: OutlineInputBorder(
            borderRadius: BorderRadius.circular(8),
            borderSide: BorderSide(
                color: ColorsConstants.instance.baseTheme.withOpacity(.5)),
          ),
          contentPadding: const EdgeInsets.symmetric(horizontal: 5),
          hintText: hintTxt,
          filled: true,
          fillColor: ColorsConstants.instance.backgroundColor,
          prefixIcon: Icon(
            icon,
            color: ColorsConstants.instance.baseTheme,
          ),
        );
}
