import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:hamlemuhcrm/core/extensions/color_extension.dart';
import 'package:hamlemuhcrm/core/extensions/string_extension.dart';
import 'package:hamlemuhcrm/features/projects/view/missions_partial/project_detail_main_mission.dart';

import '../../cubit/project_cubit.dart';
import '../../widgets/multiselect_widgets/multi_select_employee.dart';
import '../../widgets/multiselect_widgets/multi_select_leaders.dart';

mixin ProjectDetailMainMissionMixin on State<ProjectDetailMainMission> {
  final TextEditingController tfGorevAd = TextEditingController();
  final TextEditingController tfAciklama = TextEditingController();

  @override
  void initState() {
    isFinish = false;
    _degerleriAta();
    isFinish = true;
    super.initState();
  }

  String dbSaatbaslangic = '';
  String dbSaatbitis = '';
  String gosterilenSaatbaslangic = '';
  String gosterilenSaatbitis = '';

  DateTime birincidateTime = DateTime.now();
  DateTime ikincidateTime = DateTime.now();
  final DateFormat format = DateFormat.yMd('tr');

  bool baslangicSecildi = false;
  bool tarihUygun = false;

  Color? selectedcolor;

  final colorhistory = [
    Colors.red,
    Colors.amber,
    Colors.teal,
    Colors.blueGrey,
    Colors.indigo
  ];

  void _degerleriAta() {
    tfGorevAd.text = widget.gorev.gorevAd;
    tfAciklama.text = widget.gorev.gorevAciklama;
    dbSaatbaslangic = widget.gorev.dbSaatbaslangic;
    dbSaatbitis = widget.gorev.dbSaatbitis;
    gosterilenSaatbaslangic = "".toTrTypeNoHour(widget.gorev.dbSaatbaslangic);
    gosterilenSaatbitis = "".toTrTypeNoHour(widget.gorev.dbSaatbitis);
    if (widget.gorev.renkKodu != '') {
      selectedcolor = Colors.red.toColorPicker(widget.gorev.renkKodu);
    } else {
      selectedcolor = Colors.amber;
    }
    seciliGorevlileriEkle();
    seciliSorumlulariEkle();
  }

  //////////////////////////////////////////////////////////////////////////

  void seciliSorumlulariEkle() {
    if (widget.gelenGorevSorumluAdlar != ',') {
      context.read<ProjectCubit>().secilenAmirAdlar =
          widget.gelenGorevSorumluAdlar.split(',').toSet().toList();
    }

    if (widget.gorev.gorevSorumlular != ',') {
      secilenAmirList = widget.gorev.gorevSorumlular.split(',');

      context.read<ProjectCubit>().secilenAmirIdler =
          widget.gorev.gorevSorumlular.split(',');

      gonderilecekAmirIdler =
          widget.gorev.gorevSorumlular.trim().replaceAll(RegExp('^,|,\$'), '');
    }
  }

  void seciliGorevlileriEkle() {
    if (widget.gelenGorevliAdlar != ',') {
      context.read<ProjectCubit>().secilenPersonelAdlar =
          widget.gelenGorevliAdlar.split(',').toSet().toList();
    }
    if (widget.gorev.gorevliler != ',') {
      secilenPersonelList = widget.gorev.gorevliler.split(',');

      context.read<ProjectCubit>().secilenPersonelIdler =
          widget.gorev.gorevliler.split(',');

      gonderilecekPersonelIdler =
          widget.gorev.gorevliler.trim().replaceAll(RegExp('^,|,\$'), '');
    }
  }

  @override
  void deactivate() {
    super.deactivate();
    context.read<ProjectCubit>().secilenPersonelAdlar.clear();
    context.read<ProjectCubit>().secilenPersonelIdler.clear();
    context.read<ProjectCubit>().secilenAmirAdlar.clear();
    context.read<ProjectCubit>().secilenAmirIdler.clear();
  }

  bool isFinish = false;
  //////////////////////////////////////////////////////////////////////

  List<String> secilenPersonelList = [];
  String selectedPersonelValues = '';

  List<String> secilenAmirList = [];
  String selectedAmirlValues = '';

  void showMultiSelectEmployee() async {
    final List<String> items = [];

    final List<String>? results = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return MultiSelectEmployee(items: items);
      },
    );

    if (results != null) {
      setState(() {
        secilenPersonelList = results;
      });
    }
  }

  void showMultiSelectLeaders() async {
    final List<String> items2 = [];

    final List<String>? results2 = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return MultiSelectLeaders(items: items2);
      },
    );

    if (results2 != null) {
      setState(() {
        secilenAmirList = results2;
      });
    }
  }

  String gonderilecekPersonelIdler = '';
  String gonderilecekAmirIdler = '';
}
