part of 'mission_employee_notes_cubit.dart';

// Cubit durumunu temsil eden sınıf
class MissionEmployeeState extends Equatable {
  final List<MissionEmployeeNote> calisanNotlari;
  final String stateMessage;
  final bool isLoading;
  final bool isLoaded;
  final bool isCompleted;
  final bool isError;

  @override
  List<Object?> get props => [calisanNotlari,stateMessage,isLoading, isLoaded, isError, isCompleted];

  const MissionEmployeeState({
    required this.calisanNotlari,
    required this.stateMessage,
    required this.isLoading,
    required this.isLoaded,
    required this.isCompleted,
    required this.isError,
  });

  factory MissionEmployeeState.initial() {
    return const MissionEmployeeState(
        calisanNotlari: [],
        stateMessage: '',
        isLoading: false,
        isLoaded: false,
        isError: false,
        isCompleted: false);
  }

  MissionEmployeeState copyWith({
    List<MissionEmployeeNote>? calisanNotlari,
    String? stateMessage,
    bool? isLoading,
    bool? isLoaded,
    bool? isError,
    bool? isCompleted,
  }) {
    return MissionEmployeeState(
      calisanNotlari: calisanNotlari ?? this.calisanNotlari,
      stateMessage: stateMessage ?? this.stateMessage,
      isLoading: isLoading ?? this.isLoading,
      isLoaded: isLoaded ?? this.isLoaded,
      isCompleted: isCompleted ?? this.isCompleted,
      isError: isError ?? this.isError,
    );
  }
}
