import 'package:equatable/equatable.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/data/repo/project_repository.dart';
import 'package:hamlemuhcrm/features/projects/model/mission_employee_note.dart';
import 'package:hamlemuhcrm/features/projects/model/mission_employee_note_add_model.dart';

part 'mission_employee_notes_state.dart';

class MissionEmployeeCubit extends Cubit<MissionEmployeeState> {
  MissionEmployeeCubit() : super(MissionEmployeeState.initial());

  final _repository = ProjectRepository();

  List<MissionEmployeeNote>? gelenCalisanNotlar = [];

  Future<void> fetchEmployeeNotes(
      String token, String loginuserid, String isGorevId) async {
    emit(state.copyWith(
        stateMessage: 'Yükleniyor..',
        calisanNotlari: [],
        isLoading: true,
        isCompleted: false,
        isError: false,
        isLoaded: false));
    try {
      gelenCalisanNotlar = await _repository.gorevCalisanNotlariListele(
        isGorevId,
        token,
        loginuserid,
      );
      emit(state.copyWith(
          stateMessage: '',
          calisanNotlari: gelenCalisanNotlar,
          isLoading: false,
          isCompleted: true,
          isError: false,
          isLoaded: true));
    } catch (e) {
      emit(state.copyWith(
          isLoading: false,
          isCompleted: false,
          isError: true,
          isLoaded: false,
          calisanNotlari: []));
    }
  }

  Future<void> addNewMissionNote(MissionAddNoteModel model) async {
    emit(state.copyWith(
      calisanNotlari: [],
      isLoading: true,
      isLoaded: false,
      isCompleted: false,
      isError: false,
    ));
    try {
      await _repository.addNewMissionNote(model);
      await fetchEmployeeNotes(model.token, model.loginuserid, model.isGorevId);
      emit(state.copyWith(
        stateMessage: 'Not Eklendi !',
        calisanNotlari: gelenCalisanNotlar,
        isLoading: false,
        isLoaded: true,
        isCompleted: true,
        isError: false,
      ));
    } catch (e) {
      emit(state.copyWith(
        stateMessage: 'Hata Oluştu !',
        calisanNotlari: gelenCalisanNotlar,
        isLoading: false,
        isLoaded: false,
        isCompleted: false,
        isError: true,
      ));
    }
  }

  // Future<void> acceptSuggestion(String loginUserId, String token,
  //     String gundemId, String cevap, String gundemToplantiId) async {
  //   emit(state.copyWith(
  //       bekleyenGundemler: [],
  //       onaylananGundemler: [],
  //       isLoading: true,
  //       isCompleted: false,
  //       isError: false,
  //       isLoaded: false));
  //   await _repository.acceptSuggestion(loginUserId, token, gundemId, cevap);
  //   await fetchWaitingSuggestions(token, loginUserId, gundemToplantiId);
  //   emit(state.copyWith(
  //       bekleyenGundemler: gelenBekleyenGundemListesi,
  //       onaylananGundemler: gelenOnayliGundemListesi,
  //       isLoading: false,
  //       isCompleted: true,
  //       isError: false,
  //       isLoaded: true));
  // }

  // Future<void> fakeGundemEkleme() async {
  //   emit(state.copyWith(
  //       bekleyenGundemler: [],
  //       isLoading: true,
  //       isCompleted: false,
  //       isError: false,
  //       isLoaded: false));
  //   await Future.delayed(const Duration(seconds: 2));
  //   emit(state.copyWith(
  //       bekleyenGundemler: gelenBekleyenGundemListesi,
  //       isLoading: false,
  //       isCompleted: true,
  //       isError: false,
  //       isLoaded: true));
  // }

  // Future<void> confirmSuggesstionList(
  //     String loginUserid, String token, String gundemToplantiId) async {
  //   emit(state.copyWith(
  //       bekleyenGundemler: [],
  //       isLoading: true,
  //       isCompleted: false,
  //       isError: false,
  //       isLoaded: false));
  //   gelenOnayliGundemListesi = await _repository.fetchSuggestions(
  //       token, loginUserid, gundemToplantiId, "1");
  //   emit(state.copyWith(
  //       onaylananGundemler: gelenOnayliGundemListesi,
  //       isLoading: false,
  //       isCompleted: true,
  //       isError: false,
  //       isLoaded: true));
  // }
}
