import 'package:hamlemuhcrm/core/base/base_cubit.dart';
import 'package:hamlemuhcrm/core/utility/toast_manager.dart';
import 'package:hamlemuhcrm/data/repo/home_repository.dart';
import 'package:hamlemuhcrm/data/repo/user_repository.dart';
import 'package:hamlemuhcrm/features/profile/model/profile_permission.dart';
import '../model/profile_detail.dart';
import 'profile_state.dart';

final class ProfileCubit extends BaseCubit<ProfileState> {
  ProfileCubit() : super(ProfileState.initial());

  final repo = HomeRepository();
  final profileRepo = UserRepository();

  void profilePermissionList(String token, String userid) async {
    safeEmit(state.copyWith(
        isLoading: true,
        isComplete: false,
        isError: false,
        permissionList: <ProfilePermission>[]));
    var liste = await repo.profilePermissonList(userid, token);
    liste?.sort((a, b) => b.izinIsbasiTarihi!.compareTo(a.izinIsbasiTarihi!));
    if (liste == null) {
      return safeEmit(state.copyWith(
          isLoading: false,
          isComplete: false,
          isError: true,
          permissionList: <ProfilePermission>[]));
    }
    safeEmit(state.copyWith(
        isLoading: false,
        isComplete: true,
        isError: false,
        permissionList: liste));
  }

  Future<bool> changeProfileUpdate(ProfileDetail model) async {
    final result = await profileRepo.updateProfileChange(model);

    if (result == null) return false;

    switch (result.success) {
      case 1:
        ToastManager.instance.toastMessageService('Güncellendi');
        return true;
      case 2:
        ToastManager.instance.toastMessageService('Problem Oluştu');
        return false;
      default:
        return false;
    }
  }

  void viewUpdateUserPermission(
      String token, String loginuserid, String izinId) async {
    await repo.viewUpdateUserPermission(token, loginuserid, izinId);
  }
}
