import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter_inappwebview/flutter_inappwebview.dart';
import 'package:http/http.dart' as http;
import 'package:path_provider/path_provider.dart';

class WebViewChatWidget extends StatefulWidget {
  final String url;

  const WebViewChatWidget({
    Key? key,
    required this.url,
  }) : super(key: key);

  @override
  State<WebViewChatWidget> createState() => _WebViewChatWidgetState();
}

class _WebViewChatWidgetState extends State<WebViewChatWidget> {
  late InAppWebViewController webViewController;

  late String lastClickedUrl; // Son tıklanan dosya URL'si

  bool _downloading = false; // İndirme durumunu tutmak için kullanılan değişken

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: SafeArea(
        child: Stack(
          children: [
            InAppWebView(
              initialUrlRequest: URLRequest(
                url: Uri.parse(widget.url),
              ),
              initialOptions: InAppWebViewGroupOptions(
                crossPlatform: InAppWebViewOptions(
                  javaScriptEnabled: true,
                ),
              ),
              onWebViewCreated: (controller) {
                webViewController = controller;
              },
              onLoadStop: (controller, url) async {
                // Tüm downloadButtonların tıklama olaylarını etkinleştir

                await controller.evaluateJavascript(source: """

                  var downloadLinks = document.getElementsByClassName("downloadButtonLink");

                  for (var i = 0; i < downloadLinks.length; i++) {

                    downloadLinks[i].addEventListener('click', function(e) {

                      e.preventDefault();

                      var url = this.getAttribute('href');

                      var dosyaAdi = this.getAttribute('dosyaAdi'); // Dosya adını alma

                      window.flutter_inappwebview.callHandler('downloadFile', {url: url, dosyaAdi: dosyaAdi}); // JSON objesi gönderme

                    });

                  }

                """);

                // JavaScript ile dosya indirme işlemini gerçekleştirmek için metod çağırma

                controller.addJavaScriptHandler(
                  handlerName: 'downloadFile',
                  callback: (args) async {
                    final Map<String, dynamic> fileInfo =
                        Map<String, dynamic>.from(args[0]);

                    final fileUrl = fileInfo['url'];

                    final fileName = fileInfo['dosyaAdi'];

                    lastClickedUrl = fileUrl; // Tıklanan dosya URL'sini sakla

                    setState(() {
                      _downloading = true; // İndirme durumunu güncelle
                    });

                    await _downloadFile(
                        fileUrl, fileName); // Dosya adını da geçir

                    setState(() {
                      _downloading =
                          false; // İndirme tamamlandığında durumu güncelle
                    });
                  },
                );
              },
            ),
            if (_downloading) // İndirme durumuna göre loader göster

              Container(
                color: const Color.fromARGB(178, 0, 0, 0),
                child: const Center(
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      CircularProgressIndicator(),
                      SizedBox(height: 16),
                      Center(
                        child: Text(
                          'Dosyanız indiriliyor. Lütfen bekleyin...',
                          style: TextStyle(color: Colors.white),
                          textAlign: TextAlign.center,
                        ),
                      ),
                      Center(
                        child: Text(
                          'Dosyanın Varsayılan İndirilme Yeri Android/data/{UygulamaAdı} Klasörüne Olacaktır.',
                          style: TextStyle(color: Colors.red),
                          textAlign: TextAlign.center,
                        ),
                      ),
                    ],
                  ),
                ),
              ),
          ],
        ),
      ),
    );
  }

  Future<void> _downloadFile(String fileUrl, String fileName) async {
    final url = Uri.parse(fileUrl);

    final Directory? directory = Platform.isAndroid
        ? await getExternalStorageDirectory()
        : await getApplicationDocumentsDirectory();

    final filePath = '${directory?.path}/$fileName';

    final response = await http.get(url);

    final file = File(filePath);

    await file.writeAsBytes(response.bodyBytes);

    // Dosyanın indirildiğini kullanıcıya bildir
    if (!mounted) return;
    ScaffoldMessenger.of(context).showSnackBar(
      SnackBar(
        content: Text('$fileName adlı dosya indirildi.'),
      ),
    );
  }
}
