import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../../core/constants/color_constants.dart';
import '../../../core/constants/url_services_constant.dart';
import '../../../core/extensions/responsive_extension.dart';
import '../../auth/login/cubit/login_cubit.dart';
import '../model/group_not_message.dart';

class NotMessageBox extends StatelessWidget {
  final GroupNotMessage model;
  final void Function()? onpressed;

  const NotMessageBox({
    Key? key,
    required this.model,
    this.onpressed,
  }) : super(key: key);

  // Mesajlar ana sayfada her bir sohbet grubu için gösterilen component

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onpressed,
      child: Container(
        margin: const EdgeInsets.symmetric(horizontal: 5),
        height: context.dynamicHeight(0.1),
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(5), color: Colors.transparent),
        child: ListTile(
          leading: _avatar(context, model),
          title: Text(model.kullaniciAdi ?? "${model.kullaniciSoyadi}",
              style: Theme.of(context).textTheme.labelLarge),
          subtitle: Text(
            model.kullaniciMail ?? "example@hamle.com.tr",
            style: Theme.of(context)
                .textTheme
                .labelMedium
                ?.copyWith(color: Colors.black54),
          ),
          trailing: IconButton(
              onPressed: () => showCompanyInformation(context, model),
              icon: context.read<LoginCubit>().userfirmId !=
                      model.kullaniciUserfirmId
                  ? const Icon(Icons.info)
                  : const Icon(Icons.cabin)),
        ),
      ),
    );
  }
}

Widget _avatar(BuildContext context, GroupNotMessage model) =>
    CachedNetworkImage(
      height: context.dynamicHeight(0.08),
      fit: BoxFit.fill,
      imageUrl: (model.kullaniciImage == null || model.kullaniciImage == "")
          ? URLAPIService.instance.defaultPhotoUrl
          : '${URLAPIService.instance.fileBaseURL}/upload-user/${model.kullaniciImage}',
      placeholder: (context, url) => CircleAvatar(
        radius: 30,
        backgroundColor: Colors.grey.shade200,
      ),
      imageBuilder: (context, imageProvider) {
        return CircleAvatar(
          radius: 32,
          backgroundColor: Colors.grey,
          child: CircleAvatar(
            radius: 30,
            backgroundImage: imageProvider,
          ),
        );
      },
    );



String checkCompanyNameValue(GroupNotMessage model) {
  if (model.kullaniciFirmaAdi == null) return "Eklenmemiş";
  if (model.kullaniciFirmaAdi == '') return "Eklenmemiş";
  return model.kullaniciFirmaAdi!;
}

void showCompanyInformation(BuildContext context, GroupNotMessage model) async {
  return showModalBottomSheet<void>(
      constraints: BoxConstraints(maxHeight: context.dynamicHeight(0.2)),
      context: context,
      showDragHandle: true,
      builder: (context) {
        return Center(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              ListTile(
                leading: CircleAvatar(
                  backgroundColor: Colors.transparent,
                  backgroundImage: NetworkImage(
                      '${URLAPIService.instance.fileBaseURL}/upload-user/${model.kullaniciImage}'),
                ),
                title: const Text("Firma"),
                subtitle: Text(checkCompanyNameValue(model),
                    style: Theme.of(context).textTheme.titleSmall?.copyWith(
                        color: ColorsConstants.instance.appWaterGreen)),
              ),
            ],
          ),
        );
      });
}
