import 'package:flutter/material.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../../core/constants/color_constants.dart';
import '../../../core/extensions/string_extension.dart';
import '../model/message.dart';

class MessageOwnTile extends StatelessWidget {
  const MessageOwnTile({
    Key? key,
    required this.message,
  }) : super(key: key);

  final Message message;

  static const _borderRadius = 26.0;

  // Kullanıcının gönderdiği mesajlar sağ tarafta olacak

  @override
  Widget build(BuildContext context) {
    bool isStart = message.kullaniciGonderenId == "0";
    bool isView = !(message.mesajGoruldu == "0");
    bool isFile = message.mesajDosyalar != null &&
        message.mesajDosyalar!.trim().isNotEmpty;
    final theme = Theme.of(context);
    final webSiteUrl = Uri.parse(
        'https://kontrolcrm.hamleyazilim.com/upload-message/${message.mesajLink}');
    return isStart
        ? _firstMessage(theme, message)
        : Padding(
            padding: EdgeInsets.symmetric(
                vertical: _kMessageContainerVerticalPadding,
                horizontal: _kMessageContainerHorizontalPadding),
            child: Align(
              alignment: Alignment.centerRight,
              child: Column(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.end,
                children: [
                  Container(
                      decoration: BoxDecoration(
                        color: ColorsConstants.instance.baseThemeV2,
                        borderRadius: const BorderRadius.only(
                          topLeft: Radius.circular(_borderRadius),
                          bottomRight: Radius.circular(_borderRadius),
                          bottomLeft: Radius.circular(_borderRadius),
                        ),
                      ),
                      padding: const EdgeInsets.symmetric(
                          horizontal: 15, vertical: 10),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          isFile
                              ? Column(
                                  children: [
                                    TextButton.icon(
                                      icon: const Icon(
                                        Icons.archive_outlined,
                                        size: 30,
                                      ),
                                      onPressed: () async {
                                        if (!await launchUrl(webSiteUrl)) {
                                          throw Exception(
                                              'Could not launch $webSiteUrl');
                                        }
                                      },
                                      label: Text(
                                        ''.extractFileName(
                                            message.mesajDosyalar!),
                                        style: const TextStyle(
                                            decoration:
                                                TextDecoration.underline,
                                            decorationColor: Colors.black54,
                                            color: Colors.black54),
                                      ),
                                    ),
                                  ],
                                )
                              : const SizedBox(),
                          SelectableText(
                            message.mesaj ?? '',
                            style: Theme.of(context)
                                .textTheme
                                .bodySmall
                                ?.copyWith(
                                    color: Colors.black87,
                                    fontWeight: FontWeight.w600),
                          ),
                          _messageInfo(theme.textTheme, message, isView),
                        ],
                      ))
                ],
              ),
            ),
          );
  }
}

Widget _firstMessage(ThemeData theme, Message message) => Center(
      child: Padding(
        padding: EdgeInsets.symmetric(
            vertical: _kFirstMessageVerticalPadding,
            horizontal: _kFirstMessageHorizontalPadding),
        child: Container(
          decoration: BoxDecoration(
            color: theme.colorScheme.secondary,
            borderRadius: BorderRadius.circular(12),
          ),
          child: Padding(
            padding: const EdgeInsets.symmetric(vertical: 4.0, horizontal: 12),
            child: Text(
              "${message.mesaj} - ${message.mesajVerilmetarihi?.phpToTrDayOfTime}",
              style: TextStyle(
                fontSize: 12,
                fontWeight: FontWeight.bold,
                color: theme.colorScheme.background,
              ),
            ),
          ),
        ),
      ),
    );

double get _kFirstMessageHorizontalPadding => 16.0;
double get _kFirstMessageVerticalPadding => 18.0;

double get _kMessageContainerHorizontalPadding => 10.0;
double get _kMessageContainerVerticalPadding => 5.0;

Widget _messageInfo(TextTheme textTheme, Message message, bool isView) => Row(
      mainAxisAlignment: MainAxisAlignment.end,
      children: [
        Text(message.mesajVerilmetarihi?.formattedHourMinutes ?? "--.--",
            style: textTheme.labelSmall?.copyWith(
                color: ColorsConstants.instance.navigationMeetButtonGreyColor)),
        const SizedBox(width: 5),
        _isView(isView),
      ],
    );

Widget _isView(bool isRead) {
  return switch (isRead) {
    true => Icon(
        Icons.done_all,
        color: ColorsConstants.instance.baseTheme,
        size: 15,
      ),
    false => const Icon(
        Icons.done,
        color: Colors.grey,
        size: 15,
      )
  };
}
