import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/features/message/view/message_view.dart';

import '../../../../core/constants/url_services_constant.dart';
import '../../../../data/repo/message_repository.dart';
import '../../../auth/login/cubit/login_cubit.dart';
import '../../cubit/message_cubit.dart';
import '../../model/group_latest_message.dart';
import '../../model/query/req_fetch_group.dart';
import '../../model/query/req_page_key.dart';

mixin MessageViewMixin on State<MessageView> {
  late final MessageCubit _messageCubit;
  MessageCubit get messageCubitInstance => _messageCubit;

  String pageKeyString = '';
  String webViewUrl = '';

  Future<void> callPageKeySetInitialValue(String grupIdUniq) async {
    pageKeyString = await context.read<MessageCubit>().responsePageKey(
        ReqPageKey(
            token: context.read<LoginCubit>().token,
            loginuserid: context.read<LoginCubit>().id,
            userfirmid: context.read<LoginCubit>().userfirmId));

    if (!mounted) return;
    webViewUrl =
        '${URLAPIService.instance.messageWebViewBaseURL}mesajlar/anasayfa_mesaj.php?pagekey=$pageKeyString&user=${context.read<LoginCubit>().id}&uniq=$grupIdUniq';
  }

  Future<void> navigateChatView(GroupLatestMessage model);

  @override
  void initState() {
    _messageCubit = MessageCubit(MessageRepository());
    _messageCubit.fetchGroupList(ReqFetchGroup(
        loginuserid: context.read<LoginCubit>().id,
        token: context.read<LoginCubit>().token,
        userfirmid: context.read<LoginCubit>().userfirmId));
    super.initState();
  }

  @override
  void dispose() {
    super.dispose();
  }

  void fetchGroup() {
    _messageCubit.fetchGroupList(ReqFetchGroup(
        loginuserid: context.read<LoginCubit>().id,
        token: context.read<LoginCubit>().token,
        userfirmid: context.read<LoginCubit>().userfirmId));
  }
}
