import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../../../core/constants/url_services_constant.dart';
import '../../../../core/extensions/log_extension.dart';
import '../../../../core/utility/toast_manager.dart';
import '../../../auth/login/cubit/login_cubit.dart';
import '../../cubit/message_cubit.dart';
import '../../model/group_latest_message.dart';
import '../../model/query/req_multi_group.dart';
import '../../model/query/req_page_key.dart';
import '../../widget/group_multi_select_leader.dart';
import '../../widget/group_multi_select_user.dart';
import '../chat_view.dart';
import '../group_create_view.dart';

mixin GroupCreateViewMixin on State<GroupCreateView> {
  final TextEditingController _groupNameController = TextEditingController();

  TextEditingController get groupNameController => _groupNameController;

  String gonderilecekGrupYoneticiIdler = '';
  List<String> secilenGrupYoneticiList = [];

  String gonderilecekGrupKullaniciIdler = '';
  List<String> secilenGrupKullaniciList = [];

  String pageKeyString = '';

  String webViewUrl = '';

  @override
  void initState() {
    super.initState();
    setInitialCreateUser();
  }

  @override
  void dispose() {
    _groupNameController.dispose();
    super.dispose();
  }

  @override
  void deactivate() {
    super.deactivate();
    context.read<MessageCubit>().secilenGrupYoneticileriIdler.clear();
    context.read<MessageCubit>().secilenGrupYoneticileriAdlar.clear();
    context.read<MessageCubit>().secilenGrupKullanicilariAdlar.clear();
    context.read<MessageCubit>().secilenGrupKullanicilariIdler.clear();
  }

  void showMultiSelectLeaderEmployee() async {
    final List<String> items = [];

    final List<String>? results = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return GroupLeaderMultiSelect(items: items);
      },
    );

    if (results != null) {
      setState(() {
        secilenGrupYoneticiList = results;
        List<int> personelYoneticiIdler = secilenGrupYoneticiList
            .where((eleman) => int.tryParse(eleman) != null)
            .map((eleman) => int.parse(eleman))
            .toList();
        gonderilecekGrupYoneticiIdler = personelYoneticiIdler.join(',');
      });
    }
  }

  void showMultiSelectUserEmployee() async {
    final List<String> items = [];

    final List<String>? results = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return GroupUserMultiSelect(items: items);
      },
    );

    if (results != null) {
      setState(() {
        secilenGrupKullaniciList = results;
        List<int> personelIdler = secilenGrupKullaniciList
            .where((eleman) => int.tryParse(eleman) != null)
            .map((eleman) => int.parse(eleman))
            .toList();
        gonderilecekGrupKullaniciIdler = personelIdler.join(',');
      });
    }
  }

  void setInitialCreateUser() {
    /// - Login olan kişinin id'sinin gerekli yerlere atanması

    /// - Cubit listelerine atanması
    context
        .read<MessageCubit>()
        .secilenGrupYoneticileriIdler
        .add(context.read<LoginCubit>().id);
    context
        .read<MessageCubit>()
        .secilenGrupKullanicilariIdler
        .add(context.read<LoginCubit>().id);

    gonderilecekGrupKullaniciIdler = context.read<LoginCubit>().id;
    gonderilecekGrupYoneticiIdler = context.read<LoginCubit>().id;

    /// - Login olan kişinin ad ve soyadının gerekli yerlere atanması
    context.read<MessageCubit>().secilenGrupYoneticileriAdlar.add(
        "${context.read<LoginCubit>().ad} ${context.read<LoginCubit>().soyad}");
    context.read<MessageCubit>().secilenGrupKullanicilariAdlar.add(
        "${context.read<LoginCubit>().ad} ${context.read<LoginCubit>().soyad}");
  }

  void createNewGroup() async {
    /// - Herhangi bir boş değer yok ise bu adımı atlayacak var ise aşağıdaki işlemlere geçmeyecek ve kullanıcıya boş alanlar doldurulmalı mesajı gösterilecek
    if (groupNameController.text.isEmpty ||
        gonderilecekGrupKullaniciIdler.isEmpty ||
        gonderilecekGrupYoneticiIdler.isEmpty) {
      return ToastManager.instance
          .toastMessageService("Boş Alanlar Doldurulmalı !");
    }

    /// - Model'in içi dolduruluyor

    final ReqMultiGroup createGroupModel = ReqMultiGroup(
      grupAd: _groupNameController.text,
      grupKullanicilari: gonderilecekGrupKullaniciIdler,
      grupYoneticileri: gonderilecekGrupYoneticiIdler,
      loginuserid: context.read<LoginCubit>().id,
      token: context.read<LoginCubit>().token,
      userfirmid: context.read<LoginCubit>().userfirmId,
    );

    /// - Model dolduruldu mu diye log atıldı

    'grupAd : ${createGroupModel.grupAd}'.log();
    'grupKullanicilari : ${createGroupModel.grupKullanicilari}'.log();
    'grupYoneticileri : ${createGroupModel.grupYoneticileri}'.log();

    /// - Burada yeni grup oluşturma servisine model gönderilecek ve yeni grup oluşturulacak, oluşturulan grup servisten dönecek ve o dönen grup modeli ile yeni bir chat sayfası açtırılacak
    await widget.cubit
        .createMultiGroup(createGroupModel)
        .then((value) => navigateChatView(context, value));
  }

  void callPageKeySetInitialValue(String grupIdUniq) async {
    if (!mounted) return;
    pageKeyString = await context.read<MessageCubit>().responsePageKey(
        ReqPageKey(
            token: context.read<LoginCubit>().token,
            loginuserid: context.read<LoginCubit>().id,
            userfirmid: context.read<LoginCubit>().userfirmId));

    if (!mounted) return;
    webViewUrl =
        '${URLAPIService.instance.messageWebViewBaseURL}mesajlar/anasayfa_mesaj.php?pagekey=$pageKeyString&user=${context.read<LoginCubit>().id}&uniq=$grupIdUniq';
  }

  Future<void> navigateChatView(
      BuildContext context, GroupLatestMessage model) async {
    /// - Burada servisten gelen model gönderilerek chat sayfasına yönlendirme yapıldı
    /// - pushAndRemoveUntil kullanma sebebimiz grup oluşturma sayfası kapatılsın yani bu sayfa en başta ki route'a gitsin o da message view sayfası

    if (!mounted) return;
    callPageKeySetInitialValue(model.grupIdUniq ?? '');
    Navigator.of(context).pushAndRemoveUntil(
        MaterialPageRoute(
            builder: (context) => ChatView(
                  cubit: widget.cubit,
                  model: model,
                  webView: webViewUrl,
                )),
        (route) => route.isFirst);
  }
}
