part of 'message_cubit.dart';

class MessageState extends Equatable {
  final List<GroupLatestMessage> gorusulenler;
  final List<GroupNotMessage> firmaGorusulmeyenler;
  final List<GroupNotMessage> digerGorusulmeyenler;
  final List<Message> mesajListesi;
  final MessageStatus status;
  final bool hasReachedMax;
  final String errorMessage;

  const MessageState({
    required this.gorusulenler,
    required this.mesajListesi,
    required this.firmaGorusulmeyenler,
    required this.digerGorusulmeyenler,
    required this.status,
    required this.hasReachedMax,
    required this.errorMessage,
  });
  
  factory MessageState.initial() {
    return const MessageState(
      gorusulenler: <GroupLatestMessage>[],
      firmaGorusulmeyenler: <GroupNotMessage>[],
      digerGorusulmeyenler: <GroupNotMessage>[],
      mesajListesi: <Message>[],
      status: MessageStatus.initial,
      hasReachedMax: false,
      errorMessage: '',
    );
  }

  MessageState copyWith({
    List<GroupLatestMessage>? gorusulenler,
    List<GroupNotMessage>? firmaGorusulmeyenler,
    List<GroupNotMessage>? digerGorusulmeyenler,
    List<Message>? mesajListesi,
    MessageStatus? status,
    bool? hasReachedMax,
    String? errorMessage,
  }) {
    return MessageState(
      gorusulenler: gorusulenler ?? this.gorusulenler,
      firmaGorusulmeyenler: firmaGorusulmeyenler ?? this.firmaGorusulmeyenler,
      digerGorusulmeyenler: digerGorusulmeyenler ?? this.digerGorusulmeyenler,
      mesajListesi: mesajListesi ?? this.mesajListesi,
      status: status ?? this.status,
      hasReachedMax: hasReachedMax ?? this.hasReachedMax,
      errorMessage: errorMessage ?? this.errorMessage,
    );
  }

  @override
  List<Object?> get props => [
        gorusulenler,
        firmaGorusulmeyenler,
        digerGorusulmeyenler,
        mesajListesi,
        status,
        hasReachedMax,
        errorMessage
      ];
}

enum MessageStatus {
  initial,
  loading,
  loaded,
  error,
}
