import 'package:flutter/material.dart';

import '../../../core/constants/color_constants.dart';

class ExitBottomSheet extends StatelessWidget {
  final void Function()? onpressExit;
  final void Function()? onpressCancel;

  const ExitBottomSheet({super.key, this.onpressExit, this.onpressCancel});

  @override
  Widget build(BuildContext context) {
    final TextTheme textTheme = Theme.of(context).textTheme;
    String exitAppTxt = "Çıkış Yap";
    String cancelTxt = "İptal";
    return Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        ListTile(
          onTap: onpressExit,
          leading: CircleAvatar(
            backgroundColor: ColorsConstants.instance.appGrey,
            child: Icon(
              Icons.arrow_forward_ios_rounded,
              color: ColorsConstants.instance.appBlue,
            ),
          ),
          title: Text(
            exitAppTxt,
            style: textTheme.titleMedium
                ?.copyWith(color: ColorsConstants.instance.appBlue),
          ),
        ),
        ListTile(
          onTap: onpressCancel,
          leading: CircleAvatar(
            backgroundColor: ColorsConstants.instance.appGrey,
            child: Icon(
              Icons.arrow_back_ios_rounded,
              color: ColorsConstants.instance.appRed,
            ),
          ),
          title: Text(
            cancelTxt,
            style: textTheme.titleMedium
                ?.copyWith(color: ColorsConstants.instance.appRed),
          ),
        ),
        const Spacer(),
      ],
    );
  }


}
