import 'package:flutter/material.dart';

import '../../../core/constants/color_constants.dart';
import '../../../core/route/page_route.dart';
import '../../customers/view/activities/create_activity.dart';
import '../constants/home_constants.dart';

final class CreateActivityFloatingButton extends StatelessWidget {
  const CreateActivityFloatingButton({super.key});

  @override
  Widget build(BuildContext context) {
    return FloatingActionButton(
      tooltip: HomeContants.instance.createActivityTxt,
      onPressed: () {
        Navigator.push(context, CustomPageRoute(child: const CreateActivity()));
      },
      backgroundColor: ColorsConstants.instance.baseTheme,
      child: Icon(
        Icons.add,
        size: HomeContants.instance.kFloatActiongButtonIconPlusSize,
        color: Colors.white,
      ),
    );
  }
}
