import 'package:flutter/material.dart';
import 'package:shimmer/shimmer.dart';

class ShimmerContainer extends StatelessWidget {
  final Color color;
  final double? width;
  final double paddingBottom;
  final double? height;
  final double opacity;
  final double? marginYukseklik;

  const ShimmerContainer({
    super.key,
    required this.color,
    this.paddingBottom = 10,
    this.width,
    this.height,
    required this.opacity,
    this.marginYukseklik,
  });

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.only(bottom: paddingBottom),
      child: Shimmer.fromColors(
          baseColor: Colors.grey.shade400,
          highlightColor: Colors.grey.shade100,
          enabled: true,
          child: Container(
            height: height,
            margin: EdgeInsets.symmetric(
                horizontal: 16, vertical: marginYukseklik ?? 0),
            decoration: BoxDecoration(
              color: color.withOpacity(opacity),
              borderRadius: BorderRadius.circular(5),
            ),
          )),
    );
  }
}
