import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/core/route/page_route.dart';

import '../../../../core/constants/app_constants.dart';
import '../../../../core/constants/color_constants.dart';
import '../../../../core/constants/url_services_constant.dart';
import '../../../../core/extensions/responsive_extension.dart';
import '../../../../core/utility/toast_manager.dart';
import '../../../../core/widgets/page_loading.dart';
import '../../../../data/dropdown_models/country_api.dart';
import '../../../auth/login/cubit/login_cubit.dart';
import '../../cubit/company_personal_cubit.dart';
import '../../cubit/customers_cubit.dart';
import '../../model/firmalar.dart';
import '../../widgets/int_textfield.dart';
import '../../widgets/string_textfield.dart';
import '../../widgets/web_textfield.dart';
import 'add_person_parametry.dart';
import 'list_person.dart';

class UpdateCompany extends StatefulWidget {
  final Firmalar firma;
  const UpdateCompany({super.key, required this.firma});

  @override
  State<UpdateCompany> createState() => _UpdateCompanyState();
}

class _UpdateCompanyState extends State<UpdateCompany> {
  final String baseURL = URLAPIService.baseURL;
  String? _secilen1;
  String? _secilen2;

  var data_01;
  var data_02;

  String gonderilenIL = "";
  String gonderilenILCE = "";
  final String ilid = "1";
  final String ilceid = "4";

  bool isFinish = false;

  Future<void> getData1(String token, String loginuserid) async {
    var data1Url = "$baseURL/mobil/api/dd/il_dd_pdo.php";
    var veri = {"token": token, "loginuserid": loginuserid};
    var res01 = await Dio().post(data1Url, data: FormData.fromMap(veri));
    //print("res01 = $res01");
    if (res01.statusCode == 200) {
      setState(() {
        data_01 = json.decode(res01.data.toString());
        //print("data_01 = $data_01");
      });
    } else {}
  }

  Future<void> getData2(res01, String token, String loginuserid) async {
    var data2Url = "$baseURL/mobil/api/dd/ilce_dd_pdo.php";
    var veri = {
      "il_id": _secilen1 ?? ilid,
      "token": token,
      "loginuserid": loginuserid
    };
    var res02 = await Dio().post(data2Url, data: FormData.fromMap(veri));
    //print(res02);

    if (res02.statusCode == 200) {
      setState(() {
        data_02 = json.decode(res02.data.toString());
      });
    } else {}
  }

  Widget ilListesi() {
    List<IlDDModel> ilListesi = List<IlDDModel>.from(
      data_01["harita_iller"].map(
        (i) {
          return IlDDModel.fromJSON(i);
        },
      ),
    );
    return DropdownButtonHideUnderline(
      child: DropdownButton2(
        hint: const Text("İl Seçiniz",
            style: TextStyle(
                color: Colors.grey,
                fontSize: 13.0,
                overflow: TextOverflow.visible)), //İl
        isExpanded: true,
        items: ilListesi.map((query1) {
          return DropdownMenuItem(
            value: query1.ilId,
            child: Text(
              query1.name,
              style: const TextStyle(fontSize: 12, color: Colors.black54),
            ), //value
          );
        }).toList(),
        value: _secilen1,
        onChanged: (newValue) {
          setState(() {
            _secilen1 = newValue.toString();
            final ilid = _secilen1;
            gonderilenIL = _secilen1!;
            "_secilen ilid == $_secilen1".log();
            getData2(ilid, context.read<LoginCubit>().token,
                context.read<LoginCubit>().id);
            _secilen2 = null;
          });
        },
        buttonStyleData: ButtonStyleData(
          height: context.dynamicHeight(0.054),
          width: context.dynamicWidth(0.38),
          padding: const EdgeInsets.symmetric(horizontal: 10),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants.instance.backgroundColor,
            border: Border.all(
              color: Colors.grey.withOpacity(0.2),
            ),
          ),
          elevation: 0,
        ),
        iconStyleData: IconStyleData(
          icon: const Icon(
            Icons.keyboard_arrow_down_outlined, //ilk icon
          ),
          openMenuIcon: const Icon(
              Icons.keyboard_arrow_left_outlined), //açıldıktan sonraki icon
          iconSize: 23,
          iconEnabledColor: ColorsConstants.instance.baseTheme,
          iconDisabledColor: Colors.white,
        ),
        dropdownStyleData: DropdownStyleData(
          maxHeight: context.dynamicHeight(0.09), //açılır dropdown yüksekliği
          isOverButton: false,
          width: context.dynamicWidth(0.38),
          padding: null,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants
                .instance.backgroundColor, //açılır menü arkaplan rengi
          ),
          elevation: 8,
          offset: const Offset(0, 0),
          scrollbarTheme: ScrollbarThemeData(
            thumbColor: MaterialStateColor.resolveWith((states) =>
                ColorsConstants
                    .instance.baseTheme), //dropdown scroll rengi değiştirme
            radius: const Radius.circular(10),
            thickness: MaterialStateProperty.all<double>(6),
            thumbVisibility: MaterialStateProperty.all<bool>(true),
          ),
        ),
        menuItemStyleData: const MenuItemStyleData(
          height: 35,
          padding: EdgeInsets.symmetric(horizontal: 14),
        ),
      ),
    );
  }

  Widget ilceListesi() {
    List<IlceDDModel> ilceListesi =
        List<IlceDDModel>.from(data_02['harita_ilceler'].map((i) {
      return IlceDDModel.fromJSON(i);
    }));

    return DropdownButtonHideUnderline(
      child: DropdownButton2(
        hint: const Text("İlçe",
            style: TextStyle(
                color: Colors.grey,
                fontSize: 13.0,
                overflow: TextOverflow.visible)), //İlçe
        isExpanded: true,
        items: ilceListesi.map((query2) {
          return DropdownMenuItem(
            value: query2.ilceId,
            child: Text(
              query2.name.toString().length > 14
                  ? query2.name.toString().substring(0, 13)
                  : query2.name,
              style: const TextStyle(fontSize: 13, color: Colors.black54),
            ), //DATA SENDING
          );
        }).toList(),
        value: _secilen2,
        onChanged: (newValue) {
          setState(() {
            _secilen2 = newValue.toString();
            gonderilenILCE = _secilen2!; //medium new
            "seçilen ilçe == $_secilen2".log();
          });
        },
        buttonStyleData: ButtonStyleData(
          height: context.dynamicHeight(0.054),
          width: context.dynamicWidth(0.38),
          padding: const EdgeInsets.symmetric(horizontal: 10),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants.instance.backgroundColor,
            border: Border.all(
              color: Colors.grey.withOpacity(0.2),
            ),
          ),
          elevation: 0,
        ),
        iconStyleData: IconStyleData(
          icon: const Icon(
            Icons.keyboard_arrow_down_outlined, //ilk icon
          ),
          openMenuIcon: const Icon(
              Icons.keyboard_arrow_left_outlined), //açıldıktan sonraki icon
          iconSize: 23,
          iconEnabledColor: ColorsConstants.instance.baseTheme,
          iconDisabledColor: Colors.white,
        ),
        dropdownStyleData: DropdownStyleData(
          maxHeight: context.dynamicHeight(0.09), //açılır dropdown yüksekliği
          isOverButton: false,
          width: context.dynamicWidth(0.38),
          padding: null,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants
                .instance.backgroundColor, //açılır menü arkaplan rengi
          ),
          elevation: 8,
          offset: const Offset(0, 0),
          scrollbarTheme: ScrollbarThemeData(
            thumbColor: MaterialStateColor.resolveWith((states) =>
                ColorsConstants
                    .instance.baseTheme), //dropdown scroll rengi değiştirme
            radius: const Radius.circular(10),
            thickness: MaterialStateProperty.all<double>(6),
            thumbVisibility: MaterialStateProperty.all<bool>(true),
          ),
        ),
        menuItemStyleData: const MenuItemStyleData(
          height: 35,
          padding: EdgeInsets.symmetric(horizontal: 14),
        ),
      ),
    );
  }

  Future<void> ddBilgilerCek() async {
    final String token = context.read<LoginCubit>().token;
    final String loginid = context.read<LoginCubit>().id;
    await getData1(token, loginid);
    await getData2(ilid, token, loginid);
  }

  final _updateCompanyKey = GlobalKey<FormState>();

  final tcFirmaAd = TextEditingController();

  final tcFirmaWeb = TextEditingController();

  final tcFirmaMail = TextEditingController();

  final tcFirmaVergiD = TextEditingController();

  final tcFirmaVergiN = TextEditingController();

  final tcFirmaTel = TextEditingController();

  final tcFirmaAdres = TextEditingController();

  @override
  void initState() {
    'update company initState çalıştı'.log();
    isFinish = false;
    if (widget.firma.firmaIl != "0") {
      _secilen1 = widget.firma.firmaIl;
      gonderilenIL = widget.firma.firmaIl;
    }
    if (widget.firma.firmaIlce != "0") {
      _secilen2 = widget.firma.firmaIlce;
      gonderilenILCE = widget.firma.firmaIlce;
    }
    context.read<CompanyPersonalCubit>().firmaAd = widget.firma.firmaIsim;
    tcFirmaAd.text = widget.firma.firmaIsim;
    tcFirmaWeb.text = widget.firma.firmaWeb;
    tcFirmaMail.text = widget.firma.firmaEmail;
    tcFirmaVergiD.text = widget.firma.firmaVergiDairesi;
    tcFirmaVergiN.text = widget.firma.firmaVergiNo;
    tcFirmaTel.text = widget.firma.firmaTelefon;
    tcFirmaAdres.text = widget.firma.firmaBirincilAdresi;
    ddBilgilerCek().whenComplete(() {
      isFinish = true;
    });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return isFinish
        ? Scaffold(
            appBar: AppBar(
              backgroundColor: Colors.transparent,
              elevation: 0,
              title: Text(widget.firma.firmaIsim,
                  style: GoogleFonts.inter(
                      color: Colors.black,
                      fontWeight: FontWeight.w400,
                      fontSize: 16)),
              centerTitle: true,
              actions: [
                IconButton(
                    onPressed: () {},
                    icon: const Icon(
                      Icons.notifications_none_outlined,
                      color: Colors.black,
                    )),
              ],
              leading: IconButton(
                  onPressed: () {
                    Navigator.pop(context);
                  },
                  icon: const Icon(
                    Icons.arrow_back_ios_new,
                    color: Colors.black54,
                    size: 20,
                  )),
            ),
            body: SingleChildScrollView(
              child: Padding(
                  padding: EdgeInsets.symmetric(
                      horizontal: context.dynamicHeight(0.03)),
                  child: Column(
                    children: [
                      const SizedBox(height: 4),
                      Container(
                        width: context.dynamicWidth(1),
                        decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(15),
                            color: Colors.white,
                            boxShadow: [
                              BoxShadow(
                                color: Colors.grey.withOpacity(0.2),
                                blurRadius: 7,
                                offset: const Offset(4, 5),
                              )
                            ]),
                        child: Padding(
                          padding: const EdgeInsets.symmetric(
                              vertical: 10, horizontal: 20),
                          child: Form(
                            key: _updateCompanyKey,
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Row(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    Expanded(
                                      flex: 1,
                                      child: Material(
                                        color: Colors.transparent,
                                        child: InkWell(
                                            onTap: () {
                                              Navigator.of(context)
                                                  .push(CustomPageRoute(
                                                      child: AddPersonParametry(
                                                id: widget.firma.firmaId,
                                                firmaAd: widget.firma.firmaIsim,
                                                durum: 1,
                                              )));
                                            },
                                            splashColor: ColorsConstants
                                                .instance.baseTheme
                                                .withOpacity(0.4),
                                            borderRadius:
                                                BorderRadius.circular(10),
                                            child: _navigateButton(
                                                'Çalışan Ekle',
                                                Icons.business_rounded,
                                                ColorsConstants
                                                    .instance.baseTheme)),
                                      ),
                                    ),
                                    const SizedBox(width: 14),
                                    Expanded(
                                      flex: 1,
                                      child: Material(
                                        color: Colors.transparent,
                                        child: InkWell(
                                            onTap: () {
                                              Navigator.push(
                                                  context,
                                                  CustomPageRoute(
                                                      child: ListPerson(
                                                          firmaId: widget
                                                              .firma.firmaId,
                                                          firmaAd: widget.firma
                                                              .firmaIsim)));
                                            },
                                            splashColor:
                                                Colors.blue.withOpacity(0.4),
                                            borderRadius:
                                                BorderRadius.circular(10),
                                            child: _navigateButton(
                                                'Çalışanları Gör',
                                                Icons.people_alt_outlined,
                                                Colors.blue)),
                                      ),
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 10),
                                const Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    Text(
                                      'Firma Adı',
                                      style: TextStyle(
                                          color: Colors.grey, fontSize: 11),
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 5),
                                StringTextField(
                                  textEditingController: tcFirmaAd,
                                  aciklama: '',
                                  yukseklik: context.dynamicHeight(0.05),
                                  satirSayisi: 1,
                                  kenarlik: true,
                                  golge: false,
                                  arkaplanRengi:
                                      ColorsConstants.instance.backgroundColor,
                                  tekSatirMi: true,
                                  kisitlama: 40,
                                ),
                                const SizedBox(height: 10),
                                const Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    Text(
                                      'Web Sitesi',
                                      style: TextStyle(
                                          color: Colors.grey, fontSize: 11),
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 5),
                                WebTextField(
                                  textEditingController: tcFirmaWeb,
                                  aciklama: '',
                                  yukseklik: context.dynamicHeight(0.05),
                                  satirSayisi: 1,
                                  kenarlik: true,
                                  golge: false,
                                  arkaplanRengi:
                                      ColorsConstants.instance.backgroundColor,
                                  tekSatirMi: true,
                                  kisitlama: 37,
                                ),
                                const SizedBox(height: 10),
                                const Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    Text(
                                      'Mail Adresi',
                                      style: TextStyle(
                                          color: Colors.grey, fontSize: 11),
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 5),
                                StringTextField(
                                  textEditingController: tcFirmaMail,
                                  aciklama: '',
                                  yukseklik: context.dynamicHeight(0.05),
                                  satirSayisi: 1,
                                  kenarlik: true,
                                  golge: false,
                                  arkaplanRengi:
                                      ColorsConstants.instance.backgroundColor,
                                  tekSatirMi: true,
                                  kisitlama: 70,
                                ),
                                const SizedBox(height: 10),
                                const Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    Text(
                                      'Vergi Dairesi',
                                      style: TextStyle(
                                          color: Colors.grey, fontSize: 11),
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 5),
                                StringTextField(
                                  textEditingController: tcFirmaVergiD,
                                  aciklama: '',
                                  yukseklik: context.dynamicHeight(0.05),
                                  satirSayisi: 1,
                                  kenarlik: true,
                                  golge: false,
                                  arkaplanRengi:
                                      ColorsConstants.instance.backgroundColor,
                                  tekSatirMi: true,
                                  kisitlama: 30,
                                ),
                                const SizedBox(height: 10),
                                const Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    Text(
                                      'Vergi No',
                                      style: TextStyle(
                                          color: Colors.grey, fontSize: 11),
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 5),
                                IntTextField(
                                  textEditingController: tcFirmaVergiN,
                                  aciklama: '',
                                  yukseklik: context.dynamicHeight(0.05),
                                  satirSayisi: 1,
                                  kenarlik: true,
                                  golge: false,
                                  arkaplanRengi:
                                      ColorsConstants.instance.backgroundColor,
                                  tekSatirMi: true,
                                  kisitlama: 10,
                                ),
                                const SizedBox(height: 10),
                                const Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    Text(
                                      'Telefon No',
                                      style: TextStyle(
                                          color: Colors.grey, fontSize: 11),
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 5),
                                IntTextField(
                                  textEditingController: tcFirmaTel,
                                  aciklama: '',
                                  yukseklik: context.dynamicHeight(0.05),
                                  satirSayisi: 1,
                                  kenarlik: true,
                                  golge: false,
                                  arkaplanRengi:
                                      ColorsConstants.instance.backgroundColor,
                                  tekSatirMi: true,
                                  kisitlama: 11,
                                ),
                                const SizedBox(height: 15),
                                Row(
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceBetween,
                                  children: [
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        const Text(
                                          'İl',
                                          style: TextStyle(
                                              fontSize: 11, color: Colors.grey),
                                        ),
                                        const SizedBox(height: 6),
                                        ilListesi(),
                                      ],
                                    ),
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        const Text(
                                          'İlçe',
                                          style: TextStyle(
                                              fontSize: 11, color: Colors.grey),
                                        ),
                                        const SizedBox(height: 6),
                                        ilceListesi(),
                                      ],
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 10),
                                const Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    Text(
                                      'Adres',
                                      style: TextStyle(
                                          color: Colors.grey, fontSize: 11),
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 5),
                                StringTextField(
                                  textEditingController: tcFirmaAdres,
                                  aciklama: '',
                                  yukseklik: context.dynamicHeight(0.09),
                                  satirSayisi: 3,
                                  kenarlik: true,
                                  golge: false,
                                  arkaplanRengi:
                                      ColorsConstants.instance.backgroundColor,
                                  tekSatirMi: false,
                                  kisitlama: 100,
                                ),
                                const SizedBox(height: 14),
                                Row(
                                  mainAxisAlignment: MainAxisAlignment.end,
                                  children: [
                                    Container(
                                      height: context.dynamicHeight(0.05),
                                      decoration: BoxDecoration(
                                          color: ColorsConstants
                                              .instance.baseTheme,
                                          borderRadius:
                                              BorderRadius.circular(10),
                                          boxShadow: [
                                            BoxShadow(
                                              color:
                                                  Colors.grey.withOpacity(0.4),
                                              blurRadius: 8,
                                              offset: const Offset(1, 1),
                                            )
                                          ]),
                                      child: TextButton(
                                          onPressed: widget.firma.firmaOnay ==
                                                  '0'
                                              ? () {
                                                  ScaffoldMessenger.of(context)
                                                      .showSnackBar(
                                                    SnackBar(
                                                      backgroundColor:
                                                          ColorsConstants
                                                              .instance
                                                              .backgroundColor,
                                                      content: const Text(
                                                          "Arşivden çıkarılsın mı?"),
                                                      action: SnackBarAction(
                                                        label: "Evet",
                                                        textColor: Colors.white,
                                                        onPressed: () {
                                                          context
                                                              .read<
                                                                  CustomersCubit>()
                                                              .firmaArsivdenCikar(
                                                                  widget.firma
                                                                      .firmaId,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .token,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .id);
                                                          Future.delayed(
                                                              const Duration(
                                                                  milliseconds:
                                                                      1000),
                                                              () {
                                                            Navigator.pop(
                                                                context);
                                                            context.read<CustomersCubit>().kisifirmalariListele(
                                                                context
                                                                    .read<
                                                                        LoginCubit>()
                                                                    .tip,
                                                                context
                                                                    .read<
                                                                        LoginCubit>()
                                                                    .token,
                                                                context
                                                                    .read<
                                                                        LoginCubit>()
                                                                    .id,
                                                                context
                                                                    .read<
                                                                        LoginCubit>()
                                                                    .userfirmId,
                                                                2); //tumfirmalariListele()
                                                          });
                                                        },
                                                      ),
                                                    ),
                                                  );
                                                }
                                              : () {
                                                  ScaffoldMessenger.of(context)
                                                      .showSnackBar(
                                                    SnackBar(
                                                      backgroundColor:
                                                          ColorsConstants
                                                              .instance
                                                              .backgroundColor,
                                                      content: const Text(
                                                          "Arşivlensin mi?"),
                                                      action: SnackBarAction(
                                                        label: "Evet",
                                                        textColor: Colors.white,
                                                        onPressed: () {
                                                          context
                                                              .read<
                                                                  CustomersCubit>()
                                                              .firmaArsivle(
                                                                  widget.firma
                                                                      .firmaId,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .token,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .id);
                                                          Future.delayed(
                                                              const Duration(
                                                                  milliseconds:
                                                                      1000),
                                                              () {
                                                            context
                                                                .read<
                                                                    CustomersCubit>()
                                                                .kisiArsivFirmalar(
                                                                    context
                                                                        .read<
                                                                            LoginCubit>()
                                                                        .tip,
                                                                    context
                                                                        .read<
                                                                            LoginCubit>()
                                                                        .token,
                                                                    context
                                                                        .read<
                                                                            LoginCubit>()
                                                                        .id,
                                                                    context
                                                                        .read<
                                                                            LoginCubit>()
                                                                        .userfirmId);
                                                            Navigator.pop(
                                                                context);
                                                          });
                                                        },
                                                      ),
                                                    ),
                                                  );
                                                },
                                          style: TextButton.styleFrom(
                                              backgroundColor:
                                                  Colors.transparent,
                                              shape: RoundedRectangleBorder(
                                                borderRadius:
                                                    BorderRadius.circular(10),
                                              )),
                                          child: Padding(
                                            padding: const EdgeInsets.symmetric(
                                                horizontal: 10.0),
                                            child: Text(
                                              widget.firma.firmaOnay == '0'
                                                  ? 'ARŞİVDEN ÇIKART'
                                                  : 'ARŞİVLE',
                                              style: const TextStyle(
                                                  color: Colors.white),
                                            ),
                                          )),
                                    ),
                                    const SizedBox(width: 20),
                                    _updatedButton,
                                  ],
                                ),
                              ],
                            ),
                          ),
                        ),
                      ),
                      _screenBottomEmptySpace(context),
                    ],
                  )),
            ),
          )
        : const PageLoading();
  }

  Widget _navigateButton(String text, IconData icon, Color iconRenk) {
    return Container(
      height: context.dynamicHeight(0.054),
      padding: const EdgeInsets.symmetric(horizontal: 5),
      decoration: BoxDecoration(
        color: ColorsConstants.instance.backgroundColor.withOpacity(0.8),
        border: Border.all(color: Colors.grey.withOpacity(0.3)),
        borderRadius: BorderRadius.circular(10),
      ),
      child: Row(
        children: [
          Icon(icon, color: iconRenk),
          const SizedBox(width: 6),
          Text(
            text,
            style: const TextStyle(fontSize: 11, color: Colors.black38),
          ),
        ],
      ),
    );
  }

  Widget get _updatedButton => Container(
      height: context.dynamicHeight(0.05),
      decoration: BoxDecoration(
          color: ColorsConstants.instance.baseTheme,
          borderRadius: BorderRadius.circular(10),
          boxShadow: [
            BoxShadow(
              color: Colors.grey.withOpacity(0.4),
              blurRadius: 8,
              offset: const Offset(1, 1),
            )
          ]),
      child: TextButton(
          onPressed: () => updateCompany(),
          style: TextButton.styleFrom(
              backgroundColor: Colors.transparent,
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(10),
              )),
          child: Padding(
            padding: const EdgeInsets.symmetric(horizontal: 10.0),
            child: Text(
              ApplicationConstants.instance.moduleUpdateTxt,
              style: const TextStyle(color: Colors.white),
            ),
          )));

  void updateCompany() {
    if (tcFirmaAd.text != '' &&
        tcFirmaWeb.text != '' &&
        tcFirmaMail.text != '' &&
        tcFirmaVergiD.text != '' &&
        tcFirmaVergiN.text != '' &&
        tcFirmaTel.text != '' &&
        tcFirmaAdres.text != '') {
      "validasyona takılmadı girdi paranteze".log();
      context.read<CustomersCubit>().firmaGuncelle(
            widget.firma.firmaId,
            tcFirmaAd.text,
            tcFirmaWeb.text,
            tcFirmaMail.text,
            tcFirmaVergiD.text,
            tcFirmaVergiN.text,
            tcFirmaTel.text,
            tcFirmaAdres.text,
            context.read<LoginCubit>().id,
            gonderilenIL,
            gonderilenILCE,
            context.read<LoginCubit>().token,
          );
      ToastManager.instance.toastMessageService('Firma Güncellendi');
      Future.delayed(const Duration(milliseconds: 800), () {
        context
            .read<CustomersCubit>()
            .kisifirmalariListele(
                context.read<LoginCubit>().tip,
                context.read<LoginCubit>().token,
                context.read<LoginCubit>().id,
                context.read<LoginCubit>().userfirmId,
                2) //tumfirmalariListele(2)
            .whenComplete(() {
          Navigator.pop(context);
        });
      });
    }
    if (tcFirmaAd.text == '' ||
        tcFirmaWeb.text == '' ||
        tcFirmaMail.text == '' ||
        tcFirmaVergiD.text == '' ||
        tcFirmaVergiN.text == '' ||
        tcFirmaTel.text == '' ||
        tcFirmaAdres.text == '' ||
        gonderilenIL == '' ||
        gonderilenILCE == '') {
      ToastManager.instance.toastMessageService('Eksik Alanlar Var !');
    }
  }
}

Widget _screenBottomEmptySpace(BuildContext context) {
  return SizedBox(height: context.dynamicHeight(0.06));
}
