import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_cupertino_datetime_picker/flutter_cupertino_datetime_picker.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:intl/intl.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/constants/url_services_constant.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/data/dropdown_models/personal_getdata_api.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/customers/cubit/activity_cubit.dart';
import 'package:hamlemuhcrm/features/customers/cubit/customers_cubit.dart';
import 'package:hamlemuhcrm/features/customers/view/companies/add_person_parametry.dart';
import 'package:hamlemuhcrm/features/customers/widgets/custom_activity_textfield.dart';
import 'package:hamlemuhcrm/features/customers/widgets/string_textfield.dart';

import '../../../../core/constants/app_constants.dart';
import '../../../../core/constants/color_constants.dart';
import '../../../../core/utility/toast_manager.dart';
import '../../cubit/activity_state.dart';
import '../../model/new_activity.dart';

class CreateActivityParametry extends StatefulWidget {
  final String firmaAd;
  final String firmaID;

  const CreateActivityParametry(
      {super.key, required this.firmaAd, required this.firmaID});

  @override
  State<CreateActivityParametry> createState() =>
      _CreateActivityParametryState();
}

class _CreateActivityParametryState extends State<CreateActivityParametry> {
  final tcAktiviteBaslik = TextEditingController();
  bool isFinish = false;

  Map<String, dynamic>? gelenYetkililer;
  String? _secilenYetkili;
  String gonderilenYetkiliID = "";
  bool yetkililerBosMu = false;
  String yetkiliid = "1";

  Map<String, dynamic>? gelenCalisan;
  String? _secilenCalisan;
  String gonderilenCalisanID = "";

  Future<void> yetkiliData(res01, String token, String loginuserid) async {
    var yetkililerURL = "$baseURL/mobil/api/dd/yetkili_dd_pdo.php";
    var veri = {
      "yetkili_firma_id": _secilenYetkili ?? yetkiliid,
      "token": token,
      "loginuserid": loginuserid
    };
    var yetkililerCevap =
        await Dio().post(yetkililerURL, data: FormData.fromMap(veri));
    '${yetkililerCevap.data}'.log();

    if (yetkililerCevap.statusCode == 200) {
      setState(() {
        gelenYetkililer = json.decode(yetkililerCevap.data.toString());
        yetkililerBosMu =
            gelenYetkililer.toString().contains('{firma_yetkililer: []}');
      });
    } else {}
  }

  Widget yetkiliDD() {
    List<YetkiliDDModel> personeList =
        List<YetkiliDDModel>.from(gelenYetkililer?['firma_yetkililer'].map((i) {
      return YetkiliDDModel.fromJSON(i);
    }));

    return DropdownButtonHideUnderline(
      child: DropdownButton2(
        hint: yetkililerBosMu
            ? const Text(
                'Lütfen önce yetkili ekleyin',
                style: TextStyle(fontSize: 13),
              )
            : const Text(''),
        isExpanded: true,
        items: personeList.map((personel) {
          return DropdownMenuItem(
            value: personel.yetkiliId,
            child: Text(
              personel.yetkiliAdSoyad.toString().length > 14
                  ? personel.yetkiliAdSoyad.toString().substring(0, 13)
                  : personel.yetkiliAdSoyad,
              style: FontStyles.instance.ddYazi,
            ), //DATA SENDING
          );
        }).toList(),
        value: _secilenYetkili,
        onChanged: (newValue) {
          setState(() {
            _secilenYetkili = newValue.toString();
            gonderilenYetkiliID = _secilenYetkili!; //medium new
            "seçilen personel == $_secilenYetkili".log();
          });
        },
        buttonStyleData: ButtonStyleData(
          height: context.dynamicHeight(0.054),
          width: context.dynamicWidth(0.9),
          padding: const EdgeInsets.symmetric(horizontal: 10),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                  color: Colors.grey.withOpacity(0.3),
                  offset: const Offset(0.4, 0.3),
                  blurRadius: 7)
            ],
          ),
          elevation: 0,
        ),
        iconStyleData: IconStyleData(
          icon: const Icon(
            Icons.keyboard_arrow_down_outlined, //ilk icon
          ),
          openMenuIcon: const Icon(
              Icons.keyboard_arrow_left_outlined), //açıldıktan sonraki icon
          iconSize: 23,
          iconEnabledColor: ColorsConstants.instance.baseTheme,
          iconDisabledColor: Colors.white,
        ),
        dropdownStyleData: DropdownStyleData(
          maxHeight: context.dynamicHeight(0.17),
          isOverButton: false,
          width: context.dynamicWidth(0.9),
          padding: null,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants
                .instance.backgroundColor, //açılır menü arkaplan rengi
          ),
          elevation: 8,
          offset: const Offset(0, 0),
          scrollbarTheme: ScrollbarThemeData(
            thumbColor: MaterialStateColor.resolveWith((states) =>
                ColorsConstants
                    .instance.baseTheme), //dropdown scroll rengi değiştirme
            radius: const Radius.circular(10),
            thickness: MaterialStateProperty.all<double>(6),
            thumbVisibility: MaterialStateProperty.all<bool>(true),
          ),
        ),
        menuItemStyleData: const MenuItemStyleData(
          height: 35,
          padding: EdgeInsets.symmetric(horizontal: 14),
        ),
      ),
    );
  }

  Future<void> calisanData(
      String token, String loginuserid, String userfirmid) async {
    var calisanURL = "$baseURL/mobil/api/dd/personel_dd_pdo.php";
    var veri = {
      "token": token,
      "loginuserid": loginuserid,
      "userfirmid": userfirmid
    };
    var cevapCalisan =
        await Dio().post(calisanURL, data: FormData.fromMap(veri));
    //print("res03 status code : ${res03.statusCode}");
    if (cevapCalisan.statusCode == 200) {
      setState(() {
        gelenCalisan = json.decode(cevapCalisan.data);
      });
    } else {}
  }

  Widget calisanDD() {
    List<CalisanDDModel> ilListesi = List<CalisanDDModel>.from(
      gelenCalisan?["users"].map(
        (i) {
          return CalisanDDModel.fromJSON(i);
        },
      ),
    );

    return DropdownButtonHideUnderline(
      child: DropdownButton2(
        hint: const Text(
          "",
          style: TextStyle(fontSize: 12, color: Colors.black54),
        ), //Data1
        isExpanded: true,
        items: ilListesi.map((calisan) {
          return DropdownMenuItem(
            value: calisan.id,
            child: Text('${calisan.firstName} ${calisan.lastName}',
                style: FontStyles.instance.ddYazi), //value
          );
        }).toList(),
        value: _secilenCalisan,
        onChanged: (newValue) {
          setState(() {
            _secilenCalisan = newValue.toString();
            gonderilenCalisanID = _secilenCalisan!;
            _secilenCalisan != null
                ? yetkililerBosMu = false
                : yetkililerBosMu = true;
            "_secilen CalisanID == $_secilenCalisan".log();
          });
        },
        buttonStyleData: ButtonStyleData(
          height: context.dynamicHeight(0.054),
          width: context.dynamicWidth(0.9),
          padding: const EdgeInsets.symmetric(horizontal: 10),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                  color: Colors.grey.withOpacity(0.3),
                  offset: const Offset(0.4, 0.3),
                  blurRadius: 7)
            ],
          ),
          elevation: 0,
        ),
        iconStyleData: IconStyleData(
          icon: const Icon(
            Icons.keyboard_arrow_down_outlined, //ilk icon
          ),
          openMenuIcon: const Icon(
              Icons.keyboard_arrow_left_outlined), //açıldıktan sonraki icon
          iconSize: 23,
          iconEnabledColor: ColorsConstants.instance.baseTheme,
          iconDisabledColor: Colors.white,
        ),
        dropdownStyleData: DropdownStyleData(
          maxHeight: context.dynamicHeight(0.17),
          isOverButton: false,
          width: context.dynamicWidth(0.9),
          padding: null,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants
                .instance.backgroundColor, //açılır menü arkaplan rengi
          ),
          elevation: 8,
          offset: const Offset(0, 0),
          scrollbarTheme: ScrollbarThemeData(
            thumbColor: MaterialStateColor.resolveWith((states) =>
                ColorsConstants
                    .instance.baseTheme), //dropdown scroll rengi değiştirme
            radius: const Radius.circular(10),
            thickness: MaterialStateProperty.all<double>(6),
            thumbVisibility: MaterialStateProperty.all<bool>(true),
          ),
        ),
        menuItemStyleData: const MenuItemStyleData(
          height: 35,
          padding: EdgeInsets.symmetric(horizontal: 14),
        ),
      ),
    );
  }

  Future<void> ddBilgilerCek() async {
    final String token = context.read<LoginCubit>().token;
    final String loginid = context.read<LoginCubit>().id;
    final String userfirmid = context.read<LoginCubit>().userfirmId;
    // ilk açıldığında seçili olarak login olan kişi gelecek
    _secilenCalisan = loginid;
    gonderilenCalisanID = loginid;
    await yetkiliData(widget.firmaID, token, loginid);
    await calisanData(token, loginid, userfirmid);
  }

  @override
  void initState() {
    isFinish = false;
    yetkiliid = widget.firmaID;
    ddBilgilerCek().whenComplete(() {
      isFinish = true;
    });
    super.initState();
  }

  bool saatSecildi = false;
  String dbSaat = '';
  String gosterilenSaat = '';
  var tfAciklama = TextEditingController();
  String? selectedValue;
  final String baseURL = URLAPIService.baseURL;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
        iconTheme: const IconThemeData(color: Colors.black87),
        title: Text('Aktivite Oluştur',
            style:
                GoogleFonts.inter(fontWeight: FontWeight.w400, fontSize: 16)),
        centerTitle: true,
        actions: [
          IconButton(
            onPressed: () {},
            icon: const Icon(
              Icons.notifications_none_outlined,
            ),
          ),
        ],
        leading: IconButton(
          onPressed: () =>
              Navigator.of(context).popUntil((route) => route.isFirst),
          icon: const Icon(
            Icons.arrow_back_ios_new,
          ),
        ),
      ),
      body: SingleChildScrollView(
        child: Padding(
          padding:
              EdgeInsets.symmetric(horizontal: context.dynamicHeight(0.02)),
          child: isFinish
              ? Column(
                  children: [
                    const SizedBox(height: 4),
                    Container(
                      padding: const EdgeInsets.symmetric(horizontal: 14),
                      height: context.dynamicHeight(0.164),
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                          color: Colors.white,
                          boxShadow: [
                            BoxShadow(
                              color: Colors.grey.withOpacity(0.2),
                              blurRadius: 7,
                              offset: const Offset(4, 5),
                            )
                          ]),
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                        children: [
                          CustomActivityTextField(
                              tf: tcAktiviteBaslik,
                              icon: Icons.stacked_line_chart_rounded,
                              icYazi: 'Aktivite Başlığı Giriniz..',
                              iconRenk: Colors.blue,
                              yukseklik: 0.050),
                          Container(
                            height: context.dynamicHeight(0.050),
                            decoration: BoxDecoration(
                              color: ColorsConstants.instance.backgroundColor,
                              borderRadius: BorderRadius.circular(8),
                              border: Border.all(
                                  color: Colors.grey.withOpacity(0.24),
                                  width: 1.1),
                            ),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: [
                                SizedBox(width: context.dynamicWidth(0.025)),
                                Icon(
                                  Icons.business_rounded,
                                  color: ColorsConstants.instance.baseTheme,
                                ),
                                SizedBox(width: context.dynamicWidth(0.03)),
                                Text(
                                  widget.firmaAd.length > 33
                                      ? widget.firmaAd.substring(0, 32)
                                      : widget.firmaAd,
                                  style: const TextStyle(color: Colors.grey),
                                  textAlign: TextAlign.center,
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                    const SizedBox(height: 15),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        const SizedBox(width: 5),
                        Container(
                          height: context.dynamicWidth(0.042),
                          width: context.dynamicWidth(0.042),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(7),
                            color: Colors.blue.withOpacity(0.2),
                          ),
                          child: const Icon(
                            Icons.person_outline_outlined,
                            size: 13,
                            color: Colors.blue,
                          ),
                        ),
                        const SizedBox(width: 10),
                        Row(
                          children: [
                            const Text('Görüşülen Firma Yetkilisi'),
                            SizedBox(
                              height: context.dynamicHeight(0.044),
                              width: context.dynamicWidth(0.07),
                              child: IconButton(
                                tooltip: "Yetkili Ekle",
                                onPressed: () {
                                  Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                          builder: (context) =>
                                              AddPersonParametry(
                                                  id: widget.firmaID,
                                                  firmaAd: widget.firmaAd,
                                                  durum: 3)));
                                },
                                icon: const Icon(
                                  Icons.add_circle_outlined,
                                  color: Colors.blue,
                                  size: 15,
                                ),
                              ),
                            ),
                          ],
                        ),
                        const SizedBox(height: 7),
                      ],
                    ),
                    const SizedBox(height: 5),
                    yetkiliDD(),
                    yetkililerBosMu
                        ? const SizedBox(height: 13)
                        : const SizedBox(height: 7),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        const SizedBox(width: 5),
                        Container(
                          height: context.dynamicWidth(0.042),
                          width: context.dynamicWidth(0.042),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(7),
                            color: Colors.orangeAccent.withOpacity(0.2),
                          ),
                          child: const Icon(
                            Icons.people_alt_outlined,
                            size: 13,
                            color: Colors.orangeAccent,
                          ),
                        ),
                        const SizedBox(width: 10),
                        const Text('Görüşmeye Katılan Personel'),
                      ],
                    ),
                    yetkililerBosMu
                        ? const SizedBox(height: 10)
                        : const SizedBox(height: 8),
                    calisanDD(),
                    yetkililerBosMu
                        ? const SizedBox(height: 10)
                        : const SizedBox(height: 7),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        const SizedBox(width: 5),
                        Container(
                          height: context.dynamicWidth(0.042),
                          width: context.dynamicWidth(0.042),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(7),
                            color: Colors.green.withOpacity(0.2),
                          ),
                          child: const Icon(
                            Icons.calendar_month,
                            size: 13,
                            color: Colors.green,
                          ),
                        ),
                        const SizedBox(width: 10),
                        const Text('Görüşme Tarihi'),
                      ],
                    ),
                    const SizedBox(height: 5),
                    Container(
                        height: context.dynamicHeight(0.055),
                        width: context.dynamicWidth(0.9),
                        decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(10),
                            color: Colors.white,
                            boxShadow: [
                              BoxShadow(
                                  color: Colors.grey.withOpacity(0.3),
                                  offset: const Offset(0.4, 0.3),
                                  blurRadius: 7)
                            ]),
                        child: Row(
                          children: [
                            const SizedBox(width: 10),
                            Text(
                              gosterilenSaat,
                              style: FontStyles.instance.ddYazi,
                            ),
                            const Spacer(),
                            IconButton(
                                onPressed: () {
                                  dateTimePickerWidget(context);
                                },
                                icon: Icon(
                                  Icons.keyboard_arrow_down_outlined,
                                  size: 23,
                                  color: ColorsConstants.instance.baseTheme,
                                )),
                          ],
                        )),
                    const SizedBox(height: 10),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        const SizedBox(width: 5),
                        Container(
                          height: context.dynamicWidth(0.042),
                          width: context.dynamicWidth(0.042),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(7),
                            color: Colors.purpleAccent.withOpacity(0.2),
                          ),
                          child: const Icon(
                            Icons.message_outlined,
                            size: 13,
                            color: Colors.purpleAccent,
                          ),
                        ),
                        const SizedBox(width: 10),
                        const Text('Görüşme Tipi')
                      ],
                    ),
                    Padding(
                      padding: const EdgeInsets.only(top: 8.0, bottom: 8.0),
                      child: DropdownButtonHideUnderline(
                        child: DropdownButton2(
                          isExpanded: true,
                          value: selectedValue,
                          items: ApplicationConstants.instance.callType.entries
                              .map((entry) => DropdownMenuItem<String>(
                                    value: entry.key,
                                    child: Text(
                                      entry.value,
                                      style: FontStyles.instance.ddYazi,
                                    ),
                                  ))
                              .toList(),
                          onChanged: (value) {
                            selectedValue = value;
                            setState(() {
                              context
                                  .read<CustomersCubit>()
                                  .secilenGorusmeTipi = selectedValue!;
                            });
                            'Seçilen Deger DD : $value'.log();
                            'Secilen Deger Cubit : ${context.read<CustomersCubit>().secilenGorusmeTipi}'
                                .log();
                          },
                          buttonStyleData: ButtonStyleData(
                            height: context.dynamicHeight(0.054),
                            width: context.dynamicWidth(0.9),
                            padding: const EdgeInsets.symmetric(horizontal: 10),
                            decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(10),
                                color: Colors.white,
                                boxShadow: [
                                  BoxShadow(
                                      color: Colors.grey.withOpacity(0.3),
                                      offset: const Offset(0.4, 0.3),
                                      blurRadius: 7)
                                ]),
                            elevation: 0,
                          ),
                          iconStyleData: IconStyleData(
                            icon: const Icon(
                              Icons.keyboard_arrow_down_outlined, //ilk icon
                            ),
                            openMenuIcon: const Icon(Icons
                                .keyboard_arrow_left_outlined), //açıldıktan sonraki icon
                            iconSize: 23,
                            iconEnabledColor:
                                ColorsConstants.instance.baseTheme,
                            iconDisabledColor: Colors.white,
                          ),
                          dropdownStyleData: DropdownStyleData(
                            maxHeight: context.dynamicHeight(0.17),
                            isOverButton: false,
                            width: context.dynamicWidth(0.9),
                            padding: null,
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(10),
                              color: ColorsConstants.instance
                                  .backgroundColor, //açılır menü arkaplan rengi
                            ),
                            elevation: 8,
                            offset: const Offset(0, 0),
                            scrollbarTheme: ScrollbarThemeData(
                              thumbColor: MaterialStateColor.resolveWith(
                                  (states) => ColorsConstants.instance
                                      .baseTheme), //dropdown scroll rengi değiştirme
                              radius: const Radius.circular(10),
                              thickness: MaterialStateProperty.all<double>(6),
                              thumbVisibility:
                                  MaterialStateProperty.all<bool>(true),
                            ),
                          ),
                          menuItemStyleData: const MenuItemStyleData(
                            height: 35,
                            padding: EdgeInsets.symmetric(horizontal: 14),
                          ),
                        ),
                      ),
                    ),
                    const SizedBox(height: 8),
                    const Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        SizedBox(width: 5),
                        Text(
                          'Açıklama',
                          style: TextStyle(fontSize: 13),
                        ),
                      ],
                    ),
                    const SizedBox(height: 8),
                    StringTextField(
                      textEditingController: tfAciklama,
                      aciklama: 'Lütfen açıklama giriniz..',
                      kenarlik: false,
                      satirSayisi: 3,
                      yukseklik: context.dynamicHeight(0.1),
                      arkaplanRengi: Colors.white,
                      golge: true,
                      tekSatirMi: false,
                      kisitlama: 140,
                    ),
                    const SizedBox(height: 8),
                    Padding(
                      padding: const EdgeInsets.symmetric(vertical: 8.0),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.end,
                        children: [
                          Container(
                            height: context.dynamicHeight(0.05),
                            decoration: BoxDecoration(
                                color: ColorsConstants.instance.baseTheme,
                                borderRadius: BorderRadius.circular(10),
                                boxShadow: [
                                  BoxShadow(
                                    color: Colors.grey.withOpacity(0.4),
                                    blurRadius: 8,
                                    offset: const Offset(1, 1),
                                  )
                                ]),
                            child: TextButton(
                                onPressed: () {
                                  Navigator.popUntil(
                                      context, (route) => route.isFirst);
                                },
                                style: TextButton.styleFrom(
                                    backgroundColor: Colors.transparent,
                                    shape: RoundedRectangleBorder(
                                      borderRadius: BorderRadius.circular(10),
                                    )),
                                child: const Padding(
                                  padding:
                                      EdgeInsets.symmetric(horizontal: 10.0),
                                  child: Text(
                                    'GERİ DÖN',
                                    style: TextStyle(color: Colors.white),
                                  ),
                                )),
                          ),
                          const SizedBox(width: 15),
                          _addActivity
                        ],
                      ),
                    ),
                  ],
                )
              : const Center(
                  child: CircularProgressIndicator(),
                ),
        ),
      ),
    );
  }

  Widget get _addActivity => Container(
        height: context.dynamicHeight(0.05),
        decoration: BoxDecoration(
            color: ColorsConstants.instance.baseTheme,
            borderRadius: BorderRadius.circular(10),
            boxShadow: [
              BoxShadow(
                color: Colors.grey.withOpacity(0.4),
                blurRadius: 8,
                offset: const Offset(1, 1),
              )
            ]),
        child: BlocConsumer<ActivityCubit, ActivityState>(
          listener: (context, state) {
            if (!state.isLoading & state.isComplete && !state.isCorrect) {
              ToastManager.instance.toastMessageService("Aktivite Eklendi");
            } else if (!state.isLoading & state.isComplete && state.isCorrect) {
              ToastManager.instance.toastMessageService("Aktivite Eklenemedi");
            }
          },
          builder: (context, state) => TextButton(
              onPressed: yetkililerBosMu == false
                  ? () {
                      if (gonderilenYetkiliID.isNotEmpty &&
                          gonderilenCalisanID.isNotEmpty &&
                          dbSaat.isNotEmpty &&
                          (selectedValue ?? '').isNotEmpty &&
                          tfAciklama.text.isNotEmpty &&
                          context
                              .read<CustomersCubit>()
                              .secilenGorusmeTipi
                              .isNotEmpty) {
                        context
                            .read<ActivityCubit>()
                            .aktiviteEkle(
                                NewActivityModel(
                                    token: context.read<LoginCubit>().token,
                                    gorusmeUserFirmId:
                                        context.read<LoginCubit>().userfirmId,
                                    loginuserid: context.read<LoginCubit>().id,
                                    gorusmeUserId: ',$gonderilenCalisanID,',
                                    gorusmeFirmaId: widget.firmaID,
                                    gorusmeYetkiliId: gonderilenYetkiliID,
                                    gorusmeBaslik: tcAktiviteBaslik.text,
                                    gorusmeNot: tfAciklama.text,
                                    gorusmeTip: selectedValue != null
                                        ? selectedValue!
                                        : context
                                            .read<CustomersCubit>()
                                            .secilenGorusmeTipi,
                                    gorusmeTarihi: dbSaat),
                                context.read<LoginCubit>().tip,
                                context.read<LoginCubit>().userfirmId)
                            .then((value) {
                          Navigator.pop(context);
                        });
                      } else {
                        _snackBarMessage("Eksik alanlar var!", context);
                      }
                    }
                  : () {
                      _snackBarMessage("Eksik alanlar var!", context);
                    },
              style: TextButton.styleFrom(
                  backgroundColor: Colors.transparent,
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(10),
                  )),
              child: Padding(
                padding: const EdgeInsets.symmetric(horizontal: 10),
                child: Text(
                  ApplicationConstants.instance.moduleSaveTxt,
                  style: const TextStyle(color: Colors.white),
                ),
              )),
        ),
      );

  dateTimePickerWidget(BuildContext context) {
    return DatePicker.showDatePicker(
      context,
      dateFormat: 'dd/MM/yyyy',
      locale: DateTimePickerLocale.tr,
      initialDateTime: DateTime.now(),
      minDateTime: DateTime(2005),
      maxDateTime: DateTime(2100),
      pickerTheme: DateTimePickerTheme(
        backgroundColor: ColorsConstants.instance.backgroundColor,
        confirm: Text(
          'Seç',
          style: TextStyle(color: ColorsConstants.instance.baseTheme),
        ),
      ),
      onMonthChangeStartWithFirstDate: true,
      onConfirm: (dateTime, List<int> index) {
        DateTime selectdate = dateTime;
        final gorusmeTarihi = DateFormat('yyyy-MM-dd HH:mm').format(selectdate);
        setState(() {
          dbSaat = '$gorusmeTarihi:00';
          dbSaat == '' ? saatSecildi = false : saatSecildi = true;
          gosterilenSaat = dbSaat.substring(0, 16);
          final DateFormat format = DateFormat.yMd('tr');
          var trTarih = format.format(DateTime.parse(gosterilenSaat));
          gosterilenSaat = trTarih;
          dbSaat.log();
        });
      },
    );
  }
}

void _snackBarMessage(String msg, BuildContext context) {
  ScaffoldMessenger.of(context).showSnackBar(
    SnackBar(
      backgroundColor: ColorsConstants.instance.baseTheme,
      content: Text(
        msg,
      ),
      behavior: SnackBarBehavior.floating,
      action: SnackBarAction(
        label: "Tamam",
        textColor: Colors.white,
        onPressed: () {},
      ),
    ),
  );
}
