import 'package:flutter/material.dart';

import '../../../core/constants/color_constants.dart';

class CustomCustomerTabBar extends StatelessWidget {
  final TabController tabController;
  final void Function(int index)? onPressed;
  final List<Widget> tabs;

  const CustomCustomerTabBar({super.key, required this.tabController, this.onPressed, required this.tabs});

  @override
  Widget build(BuildContext context) {
    return TabBar(
                        indicatorSize: TabBarIndicatorSize.tab,
                        labelColor: Colors.grey.shade600,
                        tabAlignment: TabAlignment.fill,
                        dividerColor: Colors.transparent,
                        indicator: BoxDecoration(
                          border: Border.all(color: Colors.grey.shade400),
                          color: ColorsConstants.instance.backgroundColor,
                          borderRadius: BorderRadius.circular(10),
                        ),
                        onTap: (index) => onPressed,
                        controller: tabController,
                        tabs: tabs,
                      );
  }
}