import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/data/repo/customers_repository.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/customers/cubit/activity_cubit.dart';
import 'package:hamlemuhcrm/features/customers/model/firmalar.dart';

import '../../../core/utility/toast_manager.dart';

class CustomersCubit extends Cubit<List<Firmalar>> {
  CustomersCubit() : super(<Firmalar>[]);

  bool arsivMi = false;
  bool firmaMi = true;
  bool aktivitelerAcikMi = false;
  bool firmaAktiviteleri = false;
  String secilenGorusmeTipi = 'gelenmusteriyuzyuze';

  List<Firmalar> firmalar = [];

  var repo = CustomersRepository();

  Future<void> kisifirmalariListele(String userTip, String token,
      String loginuserid, String userfirmid, int siralama) async {
    List<Firmalar>? gelenFirmalar = await repo.kisiFirmalariListele(
        userTip, token, loginuserid, userfirmid);
    // 1 = id ye göre sıralama
    // 2 = isme göre sıralama
    if (gelenFirmalar.isNotEmpty) {
      switch (siralama) {
        case 1:
          gelenFirmalar.sort((a, b) => a.firmaId.compareTo(b.firmaId));
          break;
        case 2:
          gelenFirmalar.sort((a, b) => a.firmaIsim.compareTo(b.firmaIsim));
          break;
        default:
          gelenFirmalar.sort((a, b) => a.firmaId.compareTo(b.firmaId));
          break;
      }
      firmalar = gelenFirmalar;
      return emit(gelenFirmalar);
    }
  }

  Future<void> kisiArsivFirmalar(String userTip, String token,
      String loginuserid, String userfirmid) async {
    var liste = await repo.kisiArsivFirmaListele(
        userTip, token, loginuserid, userfirmid);
    emit(liste);
  }

  Future<void> ara(String aramaKelimesi) async {
    var liste = <Firmalar>[];
    for (var element in firmalar) {
      if (element.firmaIsim
          .toLowerCase()
          .contains(aramaKelimesi.toLowerCase())) {
        liste.add(element);
      }
    }
    emit(liste);
  }

  Future<bool> firmaEkle(
      String firmaFirmUserId,
      String firmaIsim,
      String firmaWeb,
      String firmaEmail,
      String firmaVergiDairesi,
      String firmaVergiNo,
      String firmaTelefon,
      String firmaBirincilAdresi,
      String loginuserid,
      String firmaIl,
      String firmaIlce,
      String token,
      String userTip) async {
    final result = await repo.firmaEkle(
      firmaFirmUserId,
      firmaIsim,
      firmaWeb,
      firmaEmail,
      firmaVergiDairesi,
      firmaVergiNo,
      firmaTelefon,
      firmaBirincilAdresi,
      loginuserid, //firma_ekleyen_user_id ye karşılık olarak bu gönderilecek
      firmaIl,
      firmaIlce,
      token,
    );

    if (result == null) {
      return false;
    }

    List<Firmalar>? gelenFirmalar = await repo.kisiFirmalariListele(
        userTip, token, loginuserid, firmaFirmUserId);
    if (gelenFirmalar.isNotEmpty) {
      gelenFirmalar.sort((a, b) => a.firmaId.compareTo(b.firmaId));
      firmalar = gelenFirmalar;
      emit(firmalar);
    }

    switch (result.success) {
      case 0:
        ToastManager.instance.toastMessageService('Firma Eklenemedi!');
        return false;
      case 1:
        ToastManager.instance.toastMessageService('Firma Eklendi!');
        return true;
      default:
        return true;
    }
  }

  Future<void> firmaGuncelle(
      String firmaId,
      String firmaIsim,
      String firmaWeb,
      String firmaEmail,
      String firmaVergiDairesi,
      String firmaVergiNo,
      String firmaTelefon,
      String firmaBirincilAdresi,
      String loginuserid,
      String firmaIl,
      String firmaIlce,
      String token) async {
    await repo.firmaGuncelle(
      firmaId,
      firmaIsim,
      firmaWeb,
      firmaEmail,
      firmaVergiDairesi,
      firmaVergiNo,
      firmaTelefon,
      firmaBirincilAdresi,
      loginuserid,
      firmaIl,
      firmaIlce,
      token,
    );
  }

  Future<void> firmaArsivle(
      String firmaId, String token, String loginuserid) async {
    await repo.firmArsivle(firmaId, token, loginuserid);
  }

  Future<void> firmaArsivdenCikar(
      String firmaId, String token, String loginuserid) async {
    await repo.firmArsivdenCikar(firmaId, token, loginuserid);
  }

  Future<void> voidTabBarDegis(
      TabController tabController, BuildContext buildContext) async {
    tabController.index == 0
        ? tabController.animateTo(1,
            duration: const Duration(milliseconds: 200))
        : tabController.animateTo(0,
            duration: const Duration(milliseconds: 200));
    buildContext.read<ActivityCubit>().kisiAktiviteleriListele(
        buildContext.read<LoginCubit>().id,
        buildContext.read<LoginCubit>().token,
        buildContext.read<LoginCubit>().tip,
        buildContext.read<LoginCubit>().userfirmId,
        2);
  }
}
