import 'package:hamlemuhcrm/features/customers/model/new_activity.dart';

import '../../../core/base/base_cubit.dart';
import '../../../data/repo/activities_repository.dart';
import '../model/aktiviteler.dart';
import 'activity_state.dart';

final class ActivityCubit extends BaseCubit<ActivityState> {
  ActivityCubit({required ActivitiesRepository activitiesRepository})
      : super(ActivityState.initial());

  var activitiesRepo = ActivitiesRepository();

  bool bosGeldi = false;
  bool aktiviteYok = false;
  bool arsivleTusuAktif = false;
  List<Aktiviteler> tumAktiviteler = []; //musteriler modulu aktiviteleri
  List<Aktiviteler> firmaAktiviteler =
      []; //firmanın aktiviteleri - company activity page

  Future<void> kisiAktiviteleriListele(String loginuserid, String token,
      String tip, String userfirmid, int siralama) async {
    emit(state.copyWith(
        aktiviteler: <Aktiviteler>[], isLoading: true, isComplete: false));
    var liste1 = await activitiesRepo.kisiAktiviteleriListele(
        loginuserid, token, tip, userfirmid);
    if (liste1 != null) {
      if (siralama == 1) {
        liste1.sort((a, b) => a.gorusmeBaslik!.compareTo(b.gorusmeBaslik!));
      } else if (siralama == 2) {
        liste1.sort((a, b) => a.firmaIsim!.compareTo(b.firmaIsim!));
      } else if (siralama == 3) {
        liste1.sort((a, b) => a.gorusmeId!.compareTo(b.gorusmeId!));
      }
      tumAktiviteler = liste1;
      return safeEmit(state.copyWith(
          aktiviteler: liste1,
          isLoading: false,
          isComplete: true,
          isCorrect: false,
          isError: false));
    }
    return safeEmit(state.copyWith(
        aktiviteler: tumAktiviteler,
        isLoading: false,
        isComplete: true,
        isCorrect: false,
        isError: false));
  }

  Future<void> kisiArsivAktiviteleriListele(
      String loginuserid, String token, String tip, String userfirmid) async {
    emit(state.copyWith(
        aktiviteler: <Aktiviteler>[], isLoading: true, isComplete: false));
    final liste1 = await activitiesRepo.kisiArsivAktiviteListele(
        loginuserid, token, tip, userfirmid);
    emit(state.copyWith(
        aktiviteler: liste1, isLoading: false, isComplete: true));
  }

  Future<void> tariheGoreAktiviteListele(
    String baslangicTarihi,
    String bitisTarihi,
    String userUserfirmId,
    String loginuserid,
    String userTip,
    String token,
  ) async {
    emit(state.copyWith(
        aktiviteler: <Aktiviteler>[], isLoading: true, isComplete: false));
    var liste = await activitiesRepo.tarihegoreAktiviteleriListele(
        baslangicTarihi,
        bitisTarihi,
        userUserfirmId,
        loginuserid,
        userTip,
        token);
    emit(state.copyWith(aktiviteler: liste, isLoading: true, isComplete: true));
  }

  Future<void> firmaAktiviteleriListele(
      String gorusmeFirmaId,
      String token,
      String loginuserid,
      String userfirmid,
      String usertip,
      int siralama) async {
    emit(state.copyWith(
        aktiviteler: <Aktiviteler>[], isLoading: true, isComplete: false));
    var liste = await activitiesRepo.firmaAktiviteleriListele(
        gorusmeFirmaId, token, loginuserid, userfirmid, usertip);
    if (liste != null && liste.isEmpty) {
      aktiviteYok = true;
    } else if (liste != null && liste.isNotEmpty) {
      aktiviteYok = false;
      if (siralama == 1) {
        liste.sort((a, b) => a.gorusmeId!.compareTo(b.gorusmeId!));
      } else if (siralama == 2) {
        liste.sort((a, b) => a.firmaIsim!.compareTo(b.firmaIsim!));
      }
      firmaAktiviteler = liste;
    }
    emit(state.copyWith(
        aktiviteler: firmaAktiviteler, isLoading: false, isComplete: true));
  }

  Future<void> firmaArsivAktiviteleriListele(
      String gorusmeFirmaId,
      String token,
      String loginuserid,
      String userfirmid,
      String usertip) async {
    emit(state.copyWith(
        aktiviteler: <Aktiviteler>[], isLoading: true, isComplete: false));
    var liste = await activitiesRepo.firmaArsivAktiviteleriListele(
        gorusmeFirmaId, token, loginuserid, userfirmid, usertip);
    emit(
        state.copyWith(aktiviteler: liste, isLoading: false, isComplete: true));
  }

  Future<void> tumAktiviteleriAra(String aramaKelimesi) async {
    emit(state.copyWith(
        aktiviteler: <Aktiviteler>[], isLoading: true, isComplete: false));
    var liste = <Aktiviteler>[];
    if (tumAktiviteler.isNotEmpty) {
      for (var element in tumAktiviteler) {
        if (element.gorusmeBaslik!
            .toLowerCase()
            .contains(aramaKelimesi.toLowerCase())) {
          liste.add(element);
        }
      }
    }
    emit(
        state.copyWith(aktiviteler: liste, isLoading: false, isComplete: true));
  }

  Future<void> firmaktiviteleriAra(String aramaKelimesi) async {
    emit(state.copyWith(
        aktiviteler: <Aktiviteler>[], isLoading: true, isComplete: false));
    var liste = <Aktiviteler>[];
    if (firmaAktiviteler.isNotEmpty) {
      for (var element in firmaAktiviteler) {
        if (element.gorusmeBaslik!
            .toLowerCase()
            .contains(aramaKelimesi.toLowerCase())) {
          liste.add(element);
        }
      }
    }
    emit(
        state.copyWith(aktiviteler: liste, isLoading: false, isComplete: true));
  }

  Future<void> aktiviteEkle(
      NewActivityModel model, String userTip, String userfirmid) async {
    safeEmit(state.copyWith(
      isLoading: true,
      isComplete: false,
      isCorrect: false,
      aktiviteler: <Aktiviteler>[],
    ));
    final result = await activitiesRepo.aktiviteEkle(model);

    if (result == null) {
      return safeEmit(
          state.copyWith(isLoading: false, isComplete: true, isCorrect: true));
    }

    switch (result.success) {
      case 1:
        return safeEmit(state.copyWith(
          isComplete: true,
          isCorrect: false,
          isLoading: false,
          aktiviteler: await activitiesRepo.kisiAktiviteleriListele(
              model.loginuserid, model.token, userTip, userfirmid),
        ));
      case 0:
      default:
        return safeEmit(state.copyWith(
            isLoading: false, isComplete: true, isCorrect: true));
    }
  }

  Future<bool> aktiviteGuncelle(
      String gorusmeId,
      String gorusmeBaslik,
      String gorusmeYetkiliId,
      String gorusmeUserIdler,
      String gorusmeTarihi,
      String gorusmeTip,
      String gorusmeNot,
      String loginuserid,
      String token,
      String tip,
      String userfirmid) async {
    emit(state.copyWith(
        aktiviteler: <Aktiviteler>[], isComplete: false, isLoading: true));
    final result = await activitiesRepo.aktiviteGuncelle(
        gorusmeId,
        gorusmeBaslik,
        gorusmeYetkiliId,
        gorusmeUserIdler,
        gorusmeTarihi,
        gorusmeTip,
        gorusmeNot,
        loginuserid,
        token);

    final guncelAktiviteler = await activitiesRepo.kisiAktiviteleriListele(
        loginuserid, token, tip, userfirmid);

    if (result == null) return false;

    switch (result.success) {
      case 1:
        emit(state.copyWith(
            aktiviteler: guncelAktiviteler,
            isComplete: true,
            isLoading: false));
        return true;
      case 2:
        emit(state.copyWith(
            isError: true,
            isComplete: true,
            isCorrect: true,
            isLoading: false));
        return false;
    }

    return false;
  }

  Future<void> aktiviteArsivle(String gorusmeId, String loginuserid,
      String token, String tip, String userfirmid) async {
    emit(state.copyWith(
        aktiviteler: <Aktiviteler>[], isComplete: false, isLoading: true));
    await activitiesRepo.aktiviteArsivle(gorusmeId, loginuserid, token);
    emit(state.copyWith(
        aktiviteler: await activitiesRepo.kisiAktiviteleriListele(
            loginuserid, token, tip, userfirmid),
        isComplete: true,
        isLoading: false));
  }

  Future<void> aktiviteArsivdenCikar(String gorusmeId, String loginuserid,
      String token, String tip, String userfirmid) async {
    emit(state.copyWith(
        aktiviteler: <Aktiviteler>[], isComplete: false, isLoading: true));
    await activitiesRepo.aktiviteArsivdenCikar(gorusmeId, loginuserid, token);
    emit(state.copyWith(
        aktiviteler: await activitiesRepo.kisiAktiviteleriListele(
            loginuserid, token, tip, userfirmid),
        isComplete: true,
        isLoading: false));
  }
}
