import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

class CalendarTextFieldInput extends InputDecoration {
  CalendarTextFieldInput(BuildContext context,
      {bool isLongInput = false, String hintTxt = ''})
      : super(
            hintText: hintTxt,
            hintStyle: Theme.of(context)
                .textTheme
                .headlineSmall
                ?.copyWith(color: ColorsConstants.instance.iconColor),
            contentPadding: EdgeInsets.symmetric(
                horizontal: context.dynamicWidth(0.02),
                vertical: isLongInput ? context.dynamicHeight(0.01) : 0),
            border: const OutlineInputBorder(borderSide: BorderSide.none));
}
