import 'package:equatable/equatable.dart';
import 'package:hamlemuhcrm/features/calendar/model/suggestion_model.dart';

import '../../../core/base/base_cubit.dart';
import '../../../data/repo/calendar_repository.dart';

part 'suggestion_state.dart';

final class SuggestionCubit extends BaseCubit<SuggestionState> {
  SuggestionCubit() : super(SuggestionState.initial());

  final _repository = CalendarRepository();

  List<SuggestionModel>? gelenBekleyenGundemListesi = [];
  List<SuggestionModel>? gelenOnayliGundemListesi = [];

  Future<void> fetchWaitingSuggestions(
      String token, String loginuserid, String gundemToplantiId,
      {String gundemDurumu = "0"}) async {
    emit(state.copyWith(
        stateMessage: 'Yükleniyor..',
        bekleyenGundemler: [],
        onaylananGundemler: [],
        isLoading: true,
        isCompleted: false,
        isError: false,
        isLoaded: false));
    try {
      gelenBekleyenGundemListesi = await _repository.fetchSuggestions(
          token, loginuserid, gundemToplantiId, "0");
      gelenOnayliGundemListesi = await _repository.fetchSuggestions(
          token, loginuserid, gundemToplantiId, "1");
      emit(state.copyWith(
          stateMessage: '',
          bekleyenGundemler: gelenBekleyenGundemListesi,
          onaylananGundemler: gelenOnayliGundemListesi,
          isLoading: false,
          isCompleted: true,
          isError: false,
          isLoaded: true));
    } catch (e) {
      emit(state.copyWith(
          isLoading: false,
          isCompleted: false,
          isError: true,
          isLoaded: false,
          bekleyenGundemler: []));
    }
  }

  Future<void> addNewSuggestion(String loginUserId, String token,
      String userFirmId, String toplantiId, String gundemMetni) async {
    emit(state.copyWith(
      bekleyenGundemler: [],
      onaylananGundemler: [],
      isLoading: true,
      isLoaded: false,
      isCompleted: false,
      isError: false,
    ));
    await _repository.addNewSuggestion(
        loginUserId, token, userFirmId, toplantiId, gundemMetni);
    await fetchWaitingSuggestions(token, loginUserId, toplantiId);
    emit(state.copyWith(
      stateMessage: 'Gündem Önerisi Eklendi !',
      bekleyenGundemler: gelenBekleyenGundemListesi,
      onaylananGundemler: [],
      isLoading: false,
      isLoaded: true,
      isCompleted: true,
      isError: false,
    ));
  }

  Future<void> acceptSuggestion(String loginUserId, String token,
      String gundemId, String cevap, String gundemToplantiId) async {
    emit(state.copyWith(
        bekleyenGundemler: [],
        onaylananGundemler: [],
        isLoading: true,
        isCompleted: false,
        isError: false,
        isLoaded: false));
    await _repository.acceptSuggestion(loginUserId, token, gundemId, cevap);
    await fetchWaitingSuggestions(token, loginUserId, gundemToplantiId);
    emit(state.copyWith(
        bekleyenGundemler: gelenBekleyenGundemListesi,
        onaylananGundemler: gelenOnayliGundemListesi,
        isLoading: false,
        isCompleted: true,
        isError: false,
        isLoaded: true));
  }

  Future<void> fakeGundemEkleme() async {
    emit(state.copyWith(
        bekleyenGundemler: [],
        isLoading: true,
        isCompleted: false,
        isError: false,
        isLoaded: false));
    await Future.delayed(const Duration(seconds: 2));
    emit(state.copyWith(
        bekleyenGundemler: gelenBekleyenGundemListesi,
        isLoading: false,
        isCompleted: true,
        isError: false,
        isLoaded: true));
  }

  Future<void> confirmSuggesstionList(
      String loginUserid, String token, String gundemToplantiId) async {
    emit(state.copyWith(
        bekleyenGundemler: [],
        isLoading: true,
        isCompleted: false,
        isError: false,
        isLoaded: false));
    gelenOnayliGundemListesi = await _repository.fetchSuggestions(
        token, loginUserid, gundemToplantiId, "1");
    emit(state.copyWith(
        onaylananGundemler: gelenOnayliGundemListesi,
        isLoading: false,
        isCompleted: true,
        isError: false,
        isLoaded: true));
  }
}
