import 'package:flutter/material.dart';
import '../../../../core/extensions/responsive_extension.dart';
import 'login_constants.dart';

import '../../../../core/constants/color_constants.dart';

class PasswordTextFieldInput extends InputDecoration {
  PasswordTextFieldInput(BuildContext context, void Function()? onPressed,
      {bool isVisible = false})
      : super(
            prefixIcon: Icon(
              size: 24,
              Icons.lock_outline_sharp,
              color: ColorsConstants.instance.baseTheme.withOpacity(0.8),
            ),
            suffixIcon: isVisible
                ? IconButton(
                    onPressed: onPressed,
                    icon: const Icon(Icons.remove_red_eye))
                : IconButton(
                    onPressed: onPressed,
                    icon: const Icon(Icons.remove_red_eye_outlined)),
            hintText: LoginConstants.loginPasswordText,
            hintStyle: const TextStyle(color: Colors.black54, fontSize: 14),
            contentPadding:
                EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.05)),
            isDense: true,
            border: const OutlineInputBorder(
              borderSide: BorderSide.none,
            ));
}
