import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../features/auth/login/cubit/login_cubit.dart';
import '../../features/notification/model/notification.dart';
import '../constants/color_constants.dart';
import '../cubits/notification_cubit.dart';

class NotificationCard extends StatefulWidget {
  final NotificationModel model;
  const NotificationCard({super.key, required this.model});

  @override
  State<NotificationCard> createState() => _NotificationCardState();
}

class _NotificationCardState extends State<NotificationCard> {
  @override
  Widget build(BuildContext context) {
    final textTheme = Theme.of(context).textTheme;
    return Card(
      margin: const EdgeInsets.only(bottom: 10, left: 10, right: 10),
      borderOnForeground: false,
      // bildirim daha önce görüntülenmemiş ise 0 (sarımsı), görüntülenmiş ise 1 (yeşil)
      color: widget.model.bildirimDurumu == '0'
          ? ColorsConstants.instance.baseThemeV2
          : ColorsConstants.instance.appGrey,
      child: ExpansionTile(
        shape: const ContinuousRectangleBorder(
            borderRadius: BorderRadius.all(Radius.circular(10))),
        onExpansionChanged: (value) {
          if (value == false && widget.model.bildirimDurumu == '0') {
            context.read<NotificationCubit>().fetchNotifications(
                context.read<LoginCubit>().userfirmId,
                context.read<LoginCubit>().id,
                context.read<LoginCubit>().token);
          }
          if (widget.model.bildirimDurumu == '0') {
            context.read<NotificationCubit>().readNotifications(
                context.read<LoginCubit>().id,
                context.read<LoginCubit>().token,
                widget.model.bildirimId ?? '0',
                context.read<LoginCubit>().userfirmId);
          }
        },
        iconColor: ColorsConstants.instance.baseTheme,
        childrenPadding:
            EdgeInsets.all(_emptyExpansionTileHeightSpace(context)),
        leading: CircleAvatar(
            maxRadius: 25,
            child: ticketToIcon(widget.model.bildirimKimlik ?? 1)),
        title: Text(
          widget.model.bildirimBaslik ?? 'Başlık',
          style: textTheme.titleMedium,
        ),
        children: [
          Text(
            widget.model.bildirimMesaj ?? 'Mesaj',
            style: textTheme.bodyMedium?.copyWith(height: 1.2),
          )
        ],
      ),
    );
  }

  double _emptyExpansionTileHeightSpace(BuildContext context) =>
      context.dynamicHeight(0.03);

  Icon ticketToIcon(int? parValue) {
    int? value = parValue ?? 0;
    if (value == 0) return const Icon(Icons.home);
    if (value > 0) {
      if (value < 8) {
        return const Icon(Icons.checklist_rounded);
      } else if (value > 8 && value < 40) {
        return const Icon(Icons.calendar_month_outlined);
      } else {
        return const Icon(Icons.language_rounded);
      }
    }
    return const Icon(Icons.language_rounded);
  }
}
