import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../constants/color_constants.dart';
import '../constants/font_styles.dart';

class NotPermissionWidget extends StatelessWidget {
  final String moduleName;

  const NotPermissionWidget({super.key, required this.moduleName});

  @override
  Widget build(BuildContext context) {
    return Container(
      height: context.dynamicHeight(0.08),
      alignment: Alignment.center,
      padding: const EdgeInsets.symmetric(vertical: 10),
      child: Text(
        " Bu $moduleName Düzenleme Yetkiniz Yok",
        style: FontStyles.instance.versionTxt.copyWith(
            backgroundColor: ColorsConstants.instance.baseThemeV2,
            letterSpacing: 0.01),
      ),
    );
  }
}
