import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

extension TrTimeExtension on String {
  //static final DateFormat format = DateFormat.yMd('tr');
  static final DateFormat format = DateFormat('dd.MM.yyyy HH:mm', 'tr');

  String toTrTypeNoHour(String time) {
    return format.format(DateTime.parse(time));
  }

}

extension PhpClickableEmployeeExtension on String {
  String rawComment(String id, String isim) =>
      '<a href="$id" onclick="worktaskuser($id); return false;" style="font-weight:bold;"> @$isim </a>&nbsp;&nbsp;';
}

extension PhpDateTimeExtension on String {
  String get phpDateTimeNow => DateFormat('yyyy-MM-dd').format(DateTime.now());
}

extension PhpDateTimeToTrDayOf on String {
  // 27 Ocak 2023 Cuma
  String get phpToTrDayOfTime =>
      DateFormat('dd MMMM y EEEE', 'tr_TR').format(DateTime.parse(this));

  // 09:26
  String get formattedHourMinutes =>
      DateFormat('HH:mm').format(DateTime.parse(this));
}



extension FileNameExtension on String {
  String extractFileName(String input) {
    // "hdosyaadurlh" ifadesini bulun
    int hdosyaadurlhIndex = input.indexOf("hdosyaadurlh");

    // "hdosyaadurlh" ifadesi bulunamazsa veya metin uzunluğu yetersizse null döndürün
    if (hdosyaadurlhIndex == -1 ||
        hdosyaadurlhIndex + "hdosyaadurlh".length >= input.length) {
      return "";
    }

    // "hdosyaadurlh" ifadesinden önceki dosya adını alın
    String dosyaAdi = input.substring(0, hdosyaadurlhIndex);

    return dosyaAdi.trim().length > 21
        ? dosyaAdi.trim().substring(0, 22)
        : dosyaAdi.trim();
  }
}

extension ShortNameExtension on String {
  String shortNameExt(String name, {int maxLength = 27}) =>
      name.length > maxLength ? '${name.substring(0, maxLength - 1)}..' : name;
}

extension ToRgbColorDB on Color {
  String toRgbColorDB(Color color) {
    return 'rgb(${color.red},${color.green},${color.blue})';
  }
}

extension PhpDateTimeConvert on DateTime {
  String phpDateTimeConvertExtension(DateTime gelecekTarih) =>
      DateFormat('yyyy-MM-dd').format(gelecekTarih);
}
