import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/data/dropdown_models/project_stage_api.dart';

import '../../../../../core/constants/color_constants.dart';
import '../../../core/cubits/dropdown_cubit.dart';

class StageDropdowns extends StatefulWidget {
  final String projeId;
  final String asamaId;
  final List<AsamalarDD> asamalar;
  const StageDropdowns(
      {super.key,
      required this.projeId,
      required this.asamaId,
      required this.asamalar});

  @override
  State<StageDropdowns> createState() => _MyHomePageState();
}

class _MyHomePageState extends State<StageDropdowns> {
  String? selectedValue;

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.only(top: 8.0, bottom: 8.0),
      child: DropdownButtonHideUnderline(
        child: DropdownButton2(
          isExpanded: true,
          items: widget.asamalar
              .map((item) => DropdownMenuItem(
                    value: item.asamaId,
                    child: Text(
                      item.asamaAd ?? "",
                    ),
                  ))
              .toList(),
          value: selectedValue ?? widget.asamaId,
          onChanged: (value) {
            setState(() {
              selectedValue = value as String;
              context.read<DropdownCubit>().isStageChange = true;
              context.read<DropdownCubit>().selectedStage = selectedValue ?? "";
              debugPrint(
                  'cubitteki seçili değer : ${context.read<DropdownCubit>().selectedStage}');
            });
          },
          style: FontStyles.instance.projectbxDdyazi,
          buttonStyleData: ButtonStyleData(
            height: context.dynamicHeight(0.054),
            width: context.dynamicWidth(0.9),
            padding: const EdgeInsets.symmetric(horizontal: 10),
            decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: Colors.white,
                border: Border.all(color: Colors.grey.shade400)),
            elevation: 0,
          ),
          iconStyleData: IconStyleData(
            icon: const Icon(
              Icons.keyboard_arrow_down_outlined, //ilk icon
            ),
            openMenuIcon: const Icon(
                Icons.keyboard_arrow_left_outlined), //açıldıktan sonraki icon
            iconSize: 23,
            iconEnabledColor: ColorsConstants.instance.baseTheme,
            iconDisabledColor: Colors.white,
          ),
          dropdownStyleData: DropdownStyleData(
            maxHeight: context.dynamicHeight(0.17),
            isOverButton: false,
            padding: null,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10),
              color: ColorsConstants
                  .instance.backgroundColor, //açılır menü arkaplan rengi
            ),
            elevation: 8,
            offset: const Offset(0, 0),
            scrollbarTheme: ScrollbarThemeData(
              thumbColor: MaterialStateColor.resolveWith((states) =>
                  ColorsConstants
                      .instance.baseTheme), //dropdown scroll rengi değiştirme
              radius: const Radius.circular(10),
              thickness: MaterialStateProperty.all<double>(6),
              thumbVisibility: MaterialStateProperty.all<bool>(true),
            ),
          ),
          menuItemStyleData: const MenuItemStyleData(
            height: 35,
            padding: EdgeInsets.symmetric(horizontal: 14),
          ),
        ),
      ),
    );
  }
}
