import 'package:flutter/material.dart';

class SelectedEmployeeWidget extends StatelessWidget {
  final List<String> selectedLeaders;

  const SelectedEmployeeWidget({super.key, required this.selectedLeaders});

  @override
  Widget build(BuildContext context) {
    return Wrap(
      spacing: 4.0,
      children: selectedLeaders
          .map((e) => Chip(
                backgroundColor: Colors.grey.shade200,
                label: Text(
                  e,
                  style: Theme.of(context)
                      .textTheme
                      .labelMedium
                      ?.copyWith(color: Colors.grey.shade600),
                ),
                shadowColor: Colors.blue,
                side: const BorderSide(color: Colors.black12),
              ))
          .toList(),
    );
  }
}
