import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/color_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/features/projects/cubit/missions_cubit.dart';
import 'package:hamlemuhcrm/features/projects/model/gorevler.dart';
import '../../../core/constants/color_constants.dart';

class MissionCard extends StatefulWidget {
  final Gorevler model;
  final void Function()? onPress;

  const MissionCard({
    super.key,
    required this.model,
    this.onPress,
  });

  @override
  State<MissionCard> createState() => _MissionCardState();
}

class _MissionCardState extends State<MissionCard> {
  late final MissionsCubit missionCubit;

  @override
  void initState() {
    super.initState();
  }

  Color renkEtiketiBelirle(Gorevler model) {
    if (model.renketiketi != null && model.renketiketi != '') {
      return gelenRenk = gelenRenk.toColorPicker(model.renketiketi!);
    }
    return Colors.amber;
  }

  Color gelenRenk = Colors.amber;

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) => InkWell(
        onTap: widget.onPress ?? () {},
        child: Container(
          margin: EdgeInsets.all(context.dynamicWidth(0.02)),
          height: context.dynamicHeight(0.08), //*//
          decoration: BoxDecoration(
              border: Border.all(color: Colors.grey.withOpacity(0.3), width: 1),
              color: ColorsConstants.instance.backgroundColor,
              borderRadius: const BorderRadius.all(Radius.circular(8))),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                children: [
                  const SizedBox(width: 15),
                  Container(
                    height: context.dynamicHeight(0.05),
                    width: 5,
                    decoration: BoxDecoration(
                        color:
                            renkEtiketiBelirle(widget.model), //gorev renk kodu
                        border: Border.all(color: Colors.black12, width: 1.2)),
                  ),
                  const SizedBox(width: 15),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                          widget.model.gorevAd!.length > 18
                              ? widget.model.gorevAd!.substring(0, 17)
                              : widget.model.gorevAd!,
                          style: Theme.of(context)
                              .textTheme
                              .bodySmall
                              ?.copyWith(
                                  fontWeight: FontWeight.bold,
                                  color: Colors.grey.shade700)),
                      Text(
                        widget.model.gorevAciklama!.length > 27
                            ? '${widget.model.gorevAciklama!.substring(0, 26)}..'
                            : widget.model.gorevAciklama!,
                        style: Theme.of(context).textTheme.bodySmall,
                      ),
                    ],
                  ),
                  const Spacer(),
                  _navigateTaskListButton,
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget get _navigateTaskListButton => IconButton(
        onPressed: () {},
        icon: const Icon(Icons.list_alt_sharp),
        color: ColorsConstants.instance.baseTheme,
      );
}
