import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/projects/cubit/project_cubit.dart';

import '../../../core/constants/color_constants.dart';
import '../model/filter_chip.dart';

class FilterProjectChip extends StatefulWidget {
  const FilterProjectChip({super.key});

  @override
  State<FilterProjectChip> createState() => _FilterProjectChipState();
}

class _FilterProjectChipState extends State<FilterProjectChip> {
  List<FilterChipModel> filterList = [
    FilterChipModel(index: 0, name: 'Aktif'),
    FilterChipModel(index: 1, name: 'Arşiv'),
  ];

  ValueNotifier<int> activeIndex = ValueNotifier<int>(0);

  @override
  Widget build(BuildContext context) {
    final textTheme = Theme.of(context).textTheme;
    return Row(children: [
      ...List.generate(2, (index) {
        var chip = filterList[index];
        return ValueListenableBuilder(
          valueListenable: activeIndex,
          builder: (context, notifierValue, child) => InkWell(
            onTap: () {
              'activeIndex : ${activeIndex.value}'.log();
              'chipIndex : ${chip.index}'.log();
              activeIndex.value = chip.index;
              context.read<ProjectCubit>().changeFilterProjectList(
                  activeIndex.value,
                  context.read<LoginCubit>().id,
                  context.read<LoginCubit>().token,
                  context.read<LoginCubit>().userfirmId,
                  context.read<LoginCubit>().tip);
            },
            splashColor: Colors.transparent,
            child: Container(
              margin: const EdgeInsets.all(5),
              decoration: BoxDecoration(
                  color: activeIndex.value == chip.index
                      ? ColorsConstants.instance.baseTheme
                      : Colors.grey.shade200,
                  borderRadius: BorderRadius.circular(14),
                  border: Border.all(
                      color: activeIndex.value == chip.index
                          ? Colors.black26
                          : Colors.grey.shade400,
                      width: 1.4)),
              child: Padding(
                padding:
                    const EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                child: Text(
                  chip.name,
                  style: textTheme.titleSmall?.copyWith(
                    color: activeIndex.value == chip.index
                        ? Colors.white
                        : Colors.black45,
                  ),
                ),
              ),
            ),
          ),
        );
      })
    ]);
  }
}
