import 'dart:math';

import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/core/extensions/string_extension.dart';
import 'package:hamlemuhcrm/features/projects/model/mission_employee_note.dart';

import '../../../../../core/constants/app_constants.dart';
import '../../../../../core/constants/color_constants.dart';
import '../../../../../core/constants/url_services_constant.dart';

class EmployeeNoteCard extends StatefulWidget {
  final MissionEmployeeNote model;

  const EmployeeNoteCard({super.key, required this.model});

  @override
  State<EmployeeNoteCard> createState() => _EmployeeNoteCardState();
}

class _EmployeeNoteCardState extends State<EmployeeNoteCard> {
  @override
  Widget build(BuildContext context) {
    return _mainContainer(
      context,
      Row(
        children: [
          _startEdgeContainer(context),
          _emptySpaceWidth(context),
          Expanded(
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center, //kartı ortaladık
              children: [
                _upHeaderZone(context),
                Divider(
                    color: ColorsConstants.instance.containerBorderGreyColor,
                    thickness: 0.3),
                _downHeaderZone(context),
              ],
            ),
          ),
        ],
      ),
    );
  }

  Widget _mainContainer(BuildContext context, Widget child) {
    return Container(
        height: context.dynamicHeight(0.15),
        margin: _marginContainerAll,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(_kborderRadiusValue),
          border: Border.all(
              color: ColorsConstants.instance.containerBorderGreyColor
                  .withOpacity(0.5),
              width: 1.5),
          boxShadow: [
            BoxShadow(
                color: Colors.grey.shade200,
                blurRadius: 6,
                offset: const Offset(2, 3))
          ],
          color: Colors.white,
        ),
        child: child);
  }

  Widget _upHeaderZone(BuildContext context) =>
      Row(mainAxisAlignment: MainAxisAlignment.spaceEvenly, children: [
        _profileImage(context),
        Text(
          widget.model.userName ?? '',
          style: Theme.of(context).textTheme.bodyLarge,
        ),
        Icon(Icons.access_time_rounded,
            color: ColorsConstants.instance.containerBorderGreyColor,
            size: _kCalendarIconSize),
        Text(
          widget.model.isGirilmeTarihi != null
              ? ''.toTrTypeNoHour(widget.model.isGirilmeTarihi ?? '')
              : widget.model.isGirilmeTarihi ?? '',
          style: Theme.of(context).textTheme.bodySmall,
        ),
      ]);

  Widget _downHeaderZone(BuildContext context) => Row(
        mainAxisAlignment: MainAxisAlignment.spaceAround,
        children: [
          Icon(Icons.message_outlined,
              size: 18,
              color: ColorsConstants.instance.containerBorderGreyColor),
          _noteText
        ],
      );

  Widget get _noteText => Container(
        height: context.dynamicHeight(0.06),
        width: context.dynamicWidth(0.6),
        padding: const EdgeInsets.symmetric(horizontal: 7),
        alignment: Alignment.centerLeft,
        decoration: BoxDecoration(
            color: Colors.white, borderRadius: BorderRadius.circular(10)),
        child: SingleChildScrollView(
          scrollDirection: Axis.vertical,
          child: Text(
            widget.model.isCalisma ?? '',
            style: Theme.of(context).textTheme.labelMedium,
          ),
        ),
      );

  String titleKucult(String gelenTitle) =>
      gelenTitle.length > 28 ? '${gelenTitle.substring(0, 27)}..' : gelenTitle;

  String descriptionKucult(String gelenDescription) =>
      gelenDescription.length > 50
          ? '${gelenDescription.substring(0, 49)}..'
          : gelenDescription;

  Widget _emptySpaceWidth(BuildContext context) => SizedBox(
        width: context.dynamicWidth(0.03),
      );

  Widget _startEdgeContainer(BuildContext context) => Container(
        height: context.dynamicHeight(0.18),
        width: ApplicationConstants.instance.kEdgeStartContainerWidthLow,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.only(
              topLeft: Radius.circular(_kborderRadiusValue - 1),
              bottomLeft: Radius.circular(_kborderRadiusValue - 1)),
          color: Color((Random().nextDouble() * 0xFFFFFF).toInt())
              .withOpacity(1.0),
        ),
      );

  Widget _profileImage(BuildContext context) => CircleAvatar(
        radius: 20,
        backgroundColor: Colors.grey.shade200,
        child: CircleAvatar(
          radius: 18,
          backgroundImage: NetworkImage(
              '${URLAPIService.instance.fileBaseURL}/upload-user/${widget.model.userImage}'),
          onBackgroundImageError: (exception, stackTrace) =>
              const Icon(Icons.image_not_supported_outlined),
          backgroundColor: Colors.grey.shade100,
        ),
      );

  double get _kborderRadiusValue => 5.0;
  double get _kCalendarIconSize => 18.0;
  EdgeInsets get _marginContainerAll =>
      EdgeInsets.all(ApplicationConstants.instance.kChildContainerMargin);
}
