import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/constants/app_constants.dart';
import '../../../../../core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../utility/textfield_input_decoration.dart';

class AddTaskSheetTextField extends StatefulWidget {
  final TextEditingController tfTaskName;
  final TextEditingController tfTaskDescription;
  final void Function() onPressed;

  const AddTaskSheetTextField(
      {super.key,
      required this.tfTaskName,
      required this.tfTaskDescription,
      required this.onPressed});

  @override
  State<AddTaskSheetTextField> createState() => _AddTaskSheetTextFieldState();
}

class _AddTaskSheetTextFieldState extends State<AddTaskSheetTextField> {
  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: _emptyPaddingAll,
      child: Column(
        children: [
          _headLine("Görev Adı"),
          _emptyMinHeightSpace(context),
          _textField(widget.tfTaskName),
          _emptyWidgetHeightSpace(context),
          _headLine("Görev Açıklama"),
          _emptyMinHeightSpace(context),
          _textField(widget.tfTaskDescription),
          _emptyWidgetHeightSpace(context),
          _elevatedButton,
        ],
      ),
    );
  }

  Widget _headLine(String headline) {
    return Row(
      children: [
        Text(
          headline,
          style: FontStyles.instance.projectbxBaslik,
        ),
      ],
    );
  }

  Widget _emptyWidgetHeightSpace(BuildContext context) => SizedBox(
        height: context.dynamicHeight(0.035),
      );

  Widget _emptyMinHeightSpace(BuildContext context) => SizedBox(
        height: context.dynamicHeight(0.015),
      );

  Widget _textField(TextEditingController tfController) {
    return TextField(
      controller: tfController,
      cursorColor: Colors.grey.shade400,
      magnifierConfiguration: TextMagnifierConfiguration.disabled,
      textInputAction: TextInputAction.next,
      decoration: AddTaskTextFieldInputDecoration(),
    );
  }

  Widget get _elevatedButton => ElevatedButton(
      onPressed: widget.onPressed,
      style: ElevatedButton.styleFrom(
          backgroundColor: ColorsConstants.instance.backgroundColor),
      child: Center(child: Text(ApplicationConstants.instance.moduleSaveTxt)));

  EdgeInsets get _emptyPaddingAll => EdgeInsets.all(context.dynamicWidth(0.1));
}
