import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_cupertino_datetime_picker/flutter_cupertino_datetime_picker.dart';
import 'package:intl/intl.dart';
import 'package:hamlemuhcrm/core/extensions/color_extension.dart';
import 'package:hamlemuhcrm/core/extensions/string_extension.dart';
import 'package:hamlemuhcrm/features/projects/view/missions_partial/project_update_main_mission.dart';

import '../../../../core/constants/color_constants.dart';
import '../../../../core/utility/toast_manager.dart';
import '../../cubit/project_cubit.dart';
import '../../widgets/multiselect_widgets/multi_select_employee.dart';
import '../../widgets/multiselect_widgets/multi_select_leaders.dart';

mixin ProjectUpdateMainMissionMixin on State<ProjectUpdateMainMission> {
  final tfGorevAd = TextEditingController();
  final tfAciklama = TextEditingController();

  @override
  void initState() {
    isFinish = false;
    _degerleriAta();
    isFinish = true;
    super.initState();
  }

  String dbSaatbaslangic = '';
  String dbSaatbitis = '';
  String gosterilenSaatbaslangic = '';
  String gosterilenSaatbitis = '';

  DateTime birincidateTime = DateTime.now();
  DateTime ikincidateTime = DateTime.now();
  final DateFormat format = DateFormat.yMd('tr');

  bool baslangicSecildi = false;
  bool tarihUygun = false;

  Color? selectedcolor;

  final colorhistory = [
    Colors.red,
    Colors.amber,
    Colors.teal,
    Colors.blueGrey,
    Colors.indigo
  ];

  void _degerleriAta() {
    tfGorevAd.text = widget.gorev.gorevAd;
    tfAciklama.text = widget.gorev.gorevAciklama;
    dbSaatbaslangic = widget.gorev.dbSaatbaslangic;
    dbSaatbitis = widget.gorev.dbSaatbitis;
    gosterilenSaatbaslangic = "".toTrTypeNoHour(widget.gorev.dbSaatbaslangic);
    gosterilenSaatbitis = "".toTrTypeNoHour(widget.gorev.dbSaatbitis);
    if (widget.gorev.renkKodu != '') {
      selectedcolor = Colors.red.toColorPicker(widget.gorev.renkKodu);
    } else {
      selectedcolor = Colors.amber;
    }
    seciliGorevlileriEkle();
    seciliSorumlulariEkle();
  }

  //////////////////////////////////////////////////////////////////////////

  dateTimePickerWidget1(BuildContext context) {
    return DatePicker.showDatePicker(
      context,
      dateFormat: 'dd/MM/yyyy',
      locale: DateTimePickerLocale.tr,
      initialDateTime: DateTime.now(),
      minDateTime: DateTime(2005),
      maxDateTime: DateTime(2100),
      pickerTheme: DateTimePickerTheme(
        backgroundColor: ColorsConstants.instance.backgroundColor,
        confirm: Text(
          'Onay',
          style: TextStyle(
              color: ColorsConstants.instance.baseTheme.withOpacity(0.7)),
        ),
      ),
      onConfirm: (dateTime, List<int> index) {
        DateTime selectdate1 = dateTime;
        birincidateTime = selectdate1;
        final baslangicTarihi =
            DateFormat('yyyy-MM-dd HH:mm').format(selectdate1);
        setState(() {
          dbSaatbaslangic = '$baslangicTarihi:00';
          gosterilenSaatbaslangic = dbSaatbaslangic.substring(0, 16);
          final DateFormat format = DateFormat.yMd('tr');
          var trTarih = format.format(DateTime.parse(gosterilenSaatbaslangic));
          gosterilenSaatbaslangic = trTarih;
          baslangicSecildi = true;
        });
      },
    );
  }

  dateTimePickerWidget2(BuildContext context) {
    return DatePicker.showDatePicker(
      context,
      dateFormat: 'dd/MM/yyyy',
      locale: DateTimePickerLocale.tr,
      minDateTime: DateTime(2005),
      maxDateTime: DateTime(2100),
      pickerTheme: DateTimePickerTheme(
        backgroundColor: ColorsConstants.instance.backgroundColor,
        confirm: Text(
          'Onay',
          style: TextStyle(
              color: ColorsConstants.instance.baseTheme.withOpacity(0.7)),
        ),
      ),
      onConfirm: (dateTime, List<int> index) {
        DateTime selectdate2 = dateTime;
        ikincidateTime = selectdate2;
        final bitisTarihi = DateFormat('yyyy-MM-dd HH:mm').format(selectdate2);
        setState(() {
          dbSaatbitis = '$bitisTarihi:00';
          gosterilenSaatbitis = dbSaatbitis.substring(0, 16);
          final DateFormat format = DateFormat.yMd('tr');
          var trTarih = format.format(DateTime.parse(gosterilenSaatbitis));
          gosterilenSaatbitis = trTarih;
          if (ikincidateTime.isAfter(birincidateTime) == false) {
            gosterilenSaatbitis = '';
            ToastManager.instance
                .toastMessageService("Geçerli bir tarih seçin..");
          }
        });
      },
    );
  }

  void seciliSorumlulariEkle() {
    if (widget.gelenGorevSorumluAdlar != ',' &&
        widget.gelenGorevSorumluAdlar.isNotEmpty) {
      context.read<ProjectCubit>().secilenAmirAdlar =
          widget.gelenGorevSorumluAdlar.split(',').toSet().toList();
    }

    if (widget.gorev.gorevSorumlular != ',' &&
        widget.gorev.gorevSorumlular.isNotEmpty) {
      secilenAmirList = widget.gorev.gorevSorumlular.split(',');

      context.read<ProjectCubit>().secilenAmirIdler =
          widget.gorev.gorevSorumlular.split(',');

      gonderilecekAmirIdler =
          widget.gorev.gorevSorumlular.trim().replaceAll(RegExp('^,|,\$'), '');
    }
  }

  void seciliGorevlileriEkle() {
    if (widget.gelenGorevliAdlar != ',' &&
        widget.gelenGorevliAdlar.isNotEmpty) {
      context.read<ProjectCubit>().secilenPersonelAdlar =
          widget.gelenGorevliAdlar.split(',').toSet().toList();
    }
    if (widget.gorev.gorevliler != ',' && widget.gorev.gorevliler.isNotEmpty) {
      secilenPersonelList = widget.gorev.gorevliler.split(',');

      context.read<ProjectCubit>().secilenPersonelIdler =
          widget.gorev.gorevliler.split(',');

      gonderilecekPersonelIdler =
          widget.gorev.gorevliler.trim().replaceAll(RegExp('^,|,\$'), '');
    }
  }

  @override
  void deactivate() {
    super.deactivate();
    context.read<ProjectCubit>().secilenPersonelAdlar.clear();
    context.read<ProjectCubit>().secilenPersonelIdler.clear();
    context.read<ProjectCubit>().secilenAmirAdlar.clear();
    context.read<ProjectCubit>().secilenAmirIdler.clear();
  }

  bool isFinish = false;
  //////////////////////////////////////////////////////////////////////

  List<String> secilenPersonelList = [];
  String selectedPersonelValues = '';

  List<String> secilenAmirList = [];
  String selectedAmirlValues = '';

  void showMultiSelectEmployee() async {
    final List<String> items = [];

    final List<String>? results = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return MultiSelectEmployee(items: items);
      },
    );

    if (results != null) {
      setState(() {
        secilenPersonelList = results;
      });
    }
  }

  void showMultiSelectLeaders() async {
    final List<String> items2 = [];

    final List<String>? results2 = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return MultiSelectLeaders(items: items2);
      },
    );

    if (results2 != null) {
      setState(() {
        secilenAmirList = results2;
      });
    }
  }

  String gonderilecekPersonelIdler = '';
  String gonderilecekAmirIdler = '';
}
