import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import '../../../../core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../../core/utility/toast_manager.dart';
import 'project_add_task_mixin.dart';

class ProjectAddTaskPage extends StatefulWidget {
  final String gorevliler;
  final String anaGorevId;
  final String gorevProjeId;

  const ProjectAddTaskPage({
    super.key,
    required this.gorevliler,
    required this.anaGorevId,
    required this.gorevProjeId,
  });

  @override
  State<ProjectAddTaskPage> createState() => _ProjectAddTaskPageState();
}

class _ProjectAddTaskPageState extends State<ProjectAddTaskPage>
    with ProjectAddTaskMixin {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: appBar(context),
      body: SingleChildScrollView(
        child: Column(
          children: [
            SizedBox(
                height: context.dynamicHeight(0.2),
                child: ImageEnums.cproject.toPageImage),
            _emptySpace(context),
            Padding(
              padding:
                  EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.07)),
              child: Column(
                children: [
                  _headLine('Ek Görev Adı'),
                  _emptySpace(context),
                  _gorevTfContainer(context, tfEkGorevAd),
                  SizedBox(height: context.dynamicHeight(0.02)),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          _headLine('Başlangıç Tarihi'),
                          _emptySpace(context),
                          Container(
                              height: context.dynamicHeight(0.055),
                              width: context.dynamicWidth(0.4),
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(10),
                                color: Colors.white,
                                border: Border.all(
                                    color: Colors.grey.withOpacity(0.6)),
                              ),
                              child: Row(
                                children: [
                                  const SizedBox(width: 10),
                                  Text(
                                    gosterilenSaatbaslangic,
                                    style: FontStyles.instance.projectbxDdyazi,
                                  ),
                                  const Spacer(),
                                  IconButton(
                                      padding: EdgeInsets.zero,
                                      onPressed: () {
                                        dateTimePickerWidget1(context);
                                      },
                                      tooltip: 'Tarih Seç',
                                      icon: Icon(
                                        Icons.calendar_month_outlined,
                                        size: 23,
                                        color:
                                            ColorsConstants.instance.baseTheme,
                                      )),
                                ],
                              )),
                        ],
                      ),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          _headLine('Bitiş Tarihi'),
                          _emptySpace(context),
                          Container(
                            height: context.dynamicHeight(0.055),
                            width: context.dynamicWidth(0.4),
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(10),
                              color: Colors.white,
                              border: Border.all(
                                color: Colors.grey.withOpacity(0.6),
                              ),
                            ),
                            child: Row(
                              children: [
                                const SizedBox(width: 10),
                                Text(
                                  gosterilenSaatbitis,
                                  style: FontStyles.instance.projectbxDdyazi,
                                ),
                                const Spacer(),
                                baslangicSecildi
                                    ? IconButton(
                                        padding: EdgeInsets.zero,
                                        onPressed: () {
                                          dateTimePickerWidget2(context);
                                        },
                                        tooltip: 'Bitiş Tarihi Seç',
                                        icon: Icon(
                                          Icons.calendar_month_outlined,
                                          size: 23,
                                          color: ColorsConstants
                                              .instance.baseTheme,
                                        ))
                                    : IconButton(
                                        padding: EdgeInsets.zero,
                                        onPressed: () {
                                          ToastManager.instance
                                              .toastMessageService(
                                                  "Başlangıç tarihini seçin..");
                                        },
                                        tooltip: 'Bitiş Tarihi Seç',
                                        icon: Icon(
                                          Icons.calendar_month_outlined,
                                          size: 23,
                                          color: ColorsConstants
                                              .instance.baseTheme,
                                        ))
                              ],
                            ),
                          ),
                        ],
                      ),
                    ],
                  ),
                  const SizedBox(height: 15),
                  _headLine('Çalışan Etiketi'),
                  _emptySpace(context),
                  tagEmployee,
                  selectedEmployee.isNotEmpty
                      ? Column(
                          children: [
                            const SizedBox(height: 15),
                            selectedEmployeeChips,
                            const SizedBox(height: 15),
                          ],
                        )
                      : const SizedBox(height: 15),
                  Column(
                    children: [
                      _headLine('Açıklama'),
                      _emptySpace(context),
                      _descriptionTfContainer(context, tfAciklama),
                    ],
                  ),
                  const SizedBox(height: 15),
                  _emptySpace(context),
                  addTaskButton,
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  AppBar appBar(BuildContext context) {
    return AppBar(
      backgroundColor: Colors.transparent,
      elevation: 0,
      title: Text('Yeni Ek Görev Ekle',
          style: FontStyles.instance.appbarTitleStyle),
      centerTitle: true,
      leading: IconButton(
          onPressed: () {
            Navigator.popUntil(context, (route) => route.isFirst);
          },
          icon: const Icon(
            Icons.arrow_back_ios_new,
            color: Colors.black54,
            size: 20,
          )),
    );
  }
}

Widget _gorevTfContainer(
        BuildContext context, TextEditingController tfEkGorevAd) =>
    Container(
      height: context.dynamicHeight(0.05),
      width: context.dynamicWidth(0.88),
      alignment: Alignment.center,
      decoration: BoxDecoration(
          color: Colors.white,
          border: Border.all(color: Colors.grey.shade400),
          borderRadius: BorderRadius.circular(10)),
      child: TextFormField(
        inputFormatters: [LengthLimitingTextInputFormatter(100)],
        style: FontStyles.instance.projectbxDdyazi,
        magnifierConfiguration: TextMagnifierConfiguration.disabled,
        validator: (value) {
          if (value!.isEmpty ||
              !RegExp(r"^[a-zA-Z]+(([',. -][a-zA-Z ])?[a-zA-Z]*)*$")
                  .hasMatch(value)) {
            tfEkGorevAd.text = 'geçersiz';
            ToastManager.instance
                .toastMessageService('Geçerli bir görev adı girin..');
          }
          return null;
        },
        textInputAction: TextInputAction.done,
        cursorColor: ColorsConstants.instance.baseTheme,
        controller: tfEkGorevAd,
        decoration: const InputDecoration(
          contentPadding: EdgeInsets.symmetric(horizontal: 5),
          border: OutlineInputBorder(borderSide: BorderSide.none),
        ),
      ),
    );

Widget _descriptionTfContainer(
        BuildContext context, TextEditingController tfAciklama) =>
    Container(
      padding: const EdgeInsets.all(5),
      height: context.dynamicHeight(0.11),
      width: context.dynamicWidth(1),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(10),
        border: Border.all(
          color: Colors.grey.withOpacity(0.6),
        ),
      ),
      child: TextFormField(
        textInputAction: TextInputAction.done,
        maxLines: 3,
        cursorColor: ColorsConstants.instance.baseTheme,
        style: FontStyles.instance.projectbxDdyazi,
        controller: tfAciklama,
        decoration: const InputDecoration(
          border: OutlineInputBorder(borderSide: BorderSide.none),
          contentPadding: EdgeInsets.symmetric(horizontal: 2),
        ),
      ),
    );

Widget _emptySpace(BuildContext context) {
  return SizedBox(
    height: context.dynamicHeight(0.01),
  );
}

Widget _headLine(String text) {
  return Row(
    children: [
      Text(
        text,
        style: FontStyles.instance.projectbxBaslik,
      ),
    ],
  );
}
