import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/features/projects/cubit/missions_cubit.dart';
import 'package:hamlemuhcrm/features/projects/cubit/missions_state.dart';
import 'package:hamlemuhcrm/features/projects/widgets/mission_card.dart';
import 'package:hamlemuhcrm/features/projects/widgets/task_card.dart';
import '../../../core/extensions/responsive_extension.dart';

import '../model/gorevler.dart';
import '../view/missions_partial/project_additional_task_view_page.dart';
import '../widgets/filter_mission_chip_list.dart';

class MissionTabBar extends StatelessWidget {
  const MissionTabBar({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: PreferredSize(
        preferredSize: Size.fromHeight(context.dynamicHeight(0.065)),
        child: AppBar(
          backgroundColor: Colors.transparent,
          elevation: 0,
          title: const FilterMissionChip(),
        ),
      ),
      body: _missionStateCubit(context),
    );
  }

  Widget _scrollBar(Widget child) {
    return Scrollbar(
      thickness: 6,
      radius: const Radius.circular(10),
      child: child,
    );
  }

  Widget _missionListView(
      BuildContext context, List<Gorevler> anagorevListesi) {
    return Padding(
      padding: _pagePaddingAll,
      child: SizedBox(
        height: context.dynamicHeight(1),
        child: _scrollBar(
          ListView.builder(
            itemCount: anagorevListesi.length,
            itemBuilder: (context, index) {
              return MissionCard(
                model: anagorevListesi[index],
                onPress: () =>
                    _navigateToTaskViewList(context, anagorevListesi[index]),
              );
            },
          ),
        ),
      ),
    );
  }

  void _navigateToTaskViewList(BuildContext context, Gorevler gorev) {
    Navigator.push(
        context,
        MaterialPageRoute(
            builder: (context) => ProjectTaskViewPage(
                  gorevler: gorev,
                )));
  }

  //ekgorev checklediğimiz görev bulunmamadı diyor buna bak..

  Widget _taskListView(BuildContext context, List<Gorevler> ekGorevListesi) {
    return Padding(
      padding: _pagePaddingAll,
      child: SizedBox(
        height: context.dynamicHeight(1),
        child: _scrollBar(
          ListView.builder(
            itemCount: ekGorevListesi.length,
            itemBuilder: (context, index) {
              return TaskCard(gorev: ekGorevListesi[index]);
            },
          ),
        ),
      ),
    );
  }

  Widget _missionStateCubit(BuildContext context) {
    return BlocBuilder<MissionsCubit, MissionState>(
      builder: (context, state) {
        if (state.status == MissionStatus.initial) {
          return const Center(
            child: Text('Yükleniyor..'),
          );
        } else if (state.status == MissionStatus.loading) {
          return const Center(
            child: CircularProgressIndicator(),
          );
        } else if (state.status == MissionStatus.error) {
          return Center(
            child: Text(state.errorMessage),
          );
        } else if (state.gorevListesi.isEmpty) {
          return Center(
            child: Text(
              'Görev Bulunamadı',
              style: Theme.of(context).textTheme.titleMedium,
            ),
          );
        } else {
          final gorevListesi = state.gorevListesi;
          if (state.missionType == 0) {
            return _missionListView(context, gorevListesi);
          } else {
            return _taskListView(context, gorevListesi);
          }
        }
      },
    );
  }
}

EdgeInsets get _pagePaddingAll => const EdgeInsets.symmetric(horizontal: 10);
