import 'package:hamlemuhcrm/features/projects/model/projeler.dart';

class ProjelerCevap {
  List<Projeler>? projeler;
  int? success;
  String? message;

  ProjelerCevap({this.projeler, this.success, this.message});

  ProjelerCevap.fromJson(Map<String, dynamic> json) {
    if (json['projeler'] != null) {
      projeler = <Projeler>[];
      json['projeler'].forEach((v) {
        projeler!.add(Projeler.fromJson(v));
      });
    }
    success = json['success'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (projeler != null) {
      data['projeler'] = projeler!.map((v) => v.toJson()).toList();
    }
    data['success'] = success;
    data['message'] = message;
    return data;
  }
}
