import 'package:hamlemuhcrm/features/projects/model/mission_employee_note.dart';

class MissionEmployeeNoteResponse {
  List<MissionEmployeeNote>? calisanKayit;
  int? success;
  String? message;

  MissionEmployeeNoteResponse({this.calisanKayit, this.success, this.message});

  MissionEmployeeNoteResponse.fromJson(Map<String, dynamic> json) {
    if (json['gorev_isler'] != null) {
      calisanKayit = <MissionEmployeeNote>[];
      json['gorev_isler'].forEach((v) {
        calisanKayit!.add(MissionEmployeeNote.fromJson(v));
      });
    }
    success = json['success'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (calisanKayit != null) {
      data['gorev_isler'] = calisanKayit!.map((v) => v.toJson()).toList();
    }
    data['success'] = success;
    data['message'] = message;
    return data;
  }
}
