import 'package:hamlemuhcrm/features/projects/model/asamalar.dart';

class AsamalarCevap {
  List<Asamalar>? asamalar;
  int? success;
  String? message;

  AsamalarCevap({this.asamalar, this.success, this.message});

  AsamalarCevap.fromJson(Map<String, dynamic> json) {
    if (json['gorev_asamalari'] != null) {
      asamalar = <Asamalar>[];
      json['gorev_asamalari'].forEach((v) {
        asamalar!.add(Asamalar.fromJson(v));
      });
    }
    success = json['success'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (asamalar != null) {
      data['gorev_asamalari'] = asamalar!.map((v) => v.toJson()).toList();
    }
    data['success'] = success;
    data['message'] = message;
    return data;
  }
}
