import 'package:flutter/material.dart';

extension RGBtoDartExtension on Color {
  Color dartColor({required String color}) {
    //gelen format - rgb(255,133,124) => çıkan format - Color.fromRGBO(255,133,124)
    String cleanString = color.replaceAll('rgb(', '').replaceAll(')', '');
    List<String> values = cleanString.split(",");
    int red = int.parse(values[0].trim());
    int green = int.parse(values[1].trim());
    int blue = int.parse(values[2].trim());
    return Color.fromRGBO(red, green, blue, 1.0);
  }
  /* Kullanım Örneği 
  Colors.white.dColor(color: widget.gorev.renkKodu)
  */
}

extension DartToRGBExtension on Color {
  Color rgbColor({required String color}) {
    //gelen format - Color => çıkan format - Color.fromRGBO(255,133,124)
    return Color.fromRGBO(red, green, blue, 1.0);
  }
}
