import 'package:equatable/equatable.dart';

import '../model/projeler.dart';

class ProjectState extends Equatable {
  final List<Projeler> projeListesi;
  final List<Projeler> arsivProjeListesi;
  final ProjectStatus status;
  final String errorMessage;

  const ProjectState({
    required this.projeListesi,
    required this.arsivProjeListesi,
    required this.status,
    required this.errorMessage,
  });

  factory ProjectState.initial() {
    return const ProjectState(
      projeListesi: <Projeler>[],
      arsivProjeListesi: <Projeler>[],
      status: ProjectStatus.initial,
      errorMessage: '',
    );
  }

  ProjectState copyWith({
    List<Projeler>? projeListesi,
    List<Projeler>? arsivProjeListesi,
    ProjectStatus? status,
    String? errorMessage,
  }) {
    return ProjectState(
      projeListesi: projeListesi ?? this.projeListesi,
      arsivProjeListesi: arsivProjeListesi ?? this.arsivProjeListesi,
      status: status ?? this.status,
      errorMessage: errorMessage ?? this.errorMessage,
    );
  }

  @override
  List<Object?> get props => [projeListesi,arsivProjeListesi, status, errorMessage];
}

enum ProjectStatus {
  initial,
  loading,
  loaded,
  error,
}
