import 'package:hamlemuhcrm/data/repo/project_repository.dart';
import '../../../core/base/base_cubit.dart';
import '../model/projeler.dart';
import 'project_state.dart';

final class ProjectCubit extends BaseCubit<ProjectState> {
  late final ProjectRepository _projectRepository;
  ProjectCubit() : super(ProjectState.initial()) {
    _projectRepository = ProjectRepository();
  }

  List<String> secilenPersonelAdlar = [];
  List<String> secilenPersonelIdler = [];

  List<String> secilenAmirAdlar = [];
  List<String> secilenAmirIdler = [];

  void selectedItemsMultiSelectReset() {
    secilenPersonelAdlar.clear();
    secilenPersonelIdler.clear();
    secilenAmirAdlar.clear();
    secilenAmirIdler.clear();
  }

  Future<void> changeFilterProjectList(int chipIndex, String loginuserid,
      String token, String userfirmid, String userType) async {
    safeEmit(state.copyWith(
        projeListesi: <Projeler>[],
        status: ProjectStatus.loading,
        errorMessage: ''));
    switch (chipIndex) {
      case 0:
        final liste = await _projectRepository.kisiprojeleriListele(
            loginuserid, token, userfirmid, userType);
        safeEmit(state.copyWith(
            projeListesi: liste,
            status: ProjectStatus.loaded,
            errorMessage: ''));
        break;
      case 1:
        var liste = await _projectRepository.kisiArsivprojeleriListele(
            loginuserid, token, userfirmid, userType);
        safeEmit(state.copyWith(
            projeListesi: liste,
            status: ProjectStatus.loaded,
            errorMessage: ''));
        break;
    }
  }

  Future<void> projeListele(String loginuserid, String token, String userfirmid,
      String userType) async {
    safeEmit(state.copyWith(
        projeListesi: <Projeler>[],
        status: ProjectStatus.loading,
        errorMessage: ''));
    final liste = await _projectRepository.kisiprojeleriListele(
        loginuserid, token, userfirmid, userType);
    safeEmit(state.copyWith(
        projeListesi: liste, status: ProjectStatus.loaded, errorMessage: ''));
  }

  Future<void> projEkle(
      String loginuserid,
      String projeUserfirmId,
      String projeFirmaId,
      String projeAd,
      String projeAciklama,
      String projeBaslangicTarihi,
      String projeBitisTarihi,
      String projeSorumlular,
      String projeGorevliler,
      String token,
      String userType) async {
    safeEmit(state.copyWith(
        projeListesi: <Projeler>[],
        status: ProjectStatus.loading,
        errorMessage: ''));
    await _projectRepository.projEkle(
        loginuserid,
        projeUserfirmId,
        projeFirmaId,
        projeAd,
        projeAciklama,
        projeBaslangicTarihi,
        projeBitisTarihi,
        projeSorumlular,
        projeGorevliler,
        token);
    final liste = await _projectRepository.kisiprojeleriListele(
        loginuserid, token, projeUserfirmId, userType);
    safeEmit(state.copyWith(
        projeListesi: liste, status: ProjectStatus.loaded, errorMessage: ''));
  }

  Future<void> projeGuncelle(
      String projeId,
      String projeFirmaId,
      String projeAd,
      String projeAciklama,
      String projeBaslangicTarihi,
      String projeBitisTarihi,
      String projeSorumlular,
      String projeGorevliler,
      String token,
      String loginuserid,
      String userfirmid,
      String userType) async {
    await _projectRepository.projeGuncelle(
        projeId,
        projeFirmaId,
        projeAd,
        projeAciklama,
        projeBaslangicTarihi,
        projeBitisTarihi,
        projeSorumlular,
        projeGorevliler,
        token,
        loginuserid);

    final liste = await _projectRepository.kisiprojeleriListele(
        loginuserid, token, userfirmid, userType);
    safeEmit(state.copyWith(
        projeListesi: liste, status: ProjectStatus.loaded, errorMessage: ''));
  }

  Future<void> projeArsivleArsivdenCikar(
      //projenin idsi, proje onay = 0 gönderilirse arşivler , 1 gönderilirse arşivden çıkarır
      String projeId,
      String projeOnay,
      String token,
      String loginuserid,
      String userfirmid,
      String userType) async {
    await _projectRepository.projeArsivleArsivdenCikar(
        projeId, projeOnay, token, loginuserid);
    final liste = await _projectRepository.kisiprojeleriListele(
        loginuserid, token, userfirmid, userType);
    safeEmit(state.copyWith(
        projeListesi: liste, status: ProjectStatus.loaded, errorMessage: ''));
  }
}
