import 'package:equatable/equatable.dart';

import '../model/gorevler.dart';

class MissionState extends Equatable {
  final List<Gorevler> gorevListesi;
  final List<Gorevler> gorevEkGorevListesi;
  final int missionType;
  final MissionStatus status;
  final String errorMessage;

  const MissionState({
    required this.gorevListesi,
    required this.gorevEkGorevListesi,
    required this.missionType,
    required this.status,
    required this.errorMessage,
  });

  factory MissionState.initial() {
    return const MissionState(
      gorevListesi: <Gorevler>[],
      gorevEkGorevListesi: <Gorevler>[],
      missionType: 0,
      status: MissionStatus.initial,
      errorMessage: '',
    );
  }

  MissionState copyWith({
    List<Gorevler>? gorevListesi,
    List<Gorevler>? gorevEkGorevListesi,
    int? missionType,
    MissionStatus? status,
    String? errorMessage,
  }) {
    return MissionState(
      gorevListesi: gorevListesi ?? this.gorevListesi,
      gorevEkGorevListesi: gorevEkGorevListesi ?? this.gorevEkGorevListesi,
      missionType: missionType ?? this.missionType,
      status: status ?? this.status,
      errorMessage: errorMessage ?? this.errorMessage,
    );
  }

  @override
  List<Object?> get props => [gorevListesi,gorevEkGorevListesi, missionType, status, errorMessage];
}

enum MissionStatus {
  initial,
  loading,
  loaded,
  error,
}
