import 'package:hamlemuhcrm/core/base/base_cubit.dart';

import 'package:hamlemuhcrm/features/projects/cubit/missions_state.dart';
import 'package:hamlemuhcrm/features/projects/view/missions_partial/model/task_add_model.dart';
import '../../../data/repo/project_repository.dart';
import '../model/gorevler.dart';
import '../view/missions_partial/model/mission_update_model.dart';

final class MissionsCubit extends BaseCubit<MissionState> {
  MissionsCubit() : super(MissionState.initial());

  var repo = ProjectRepository();

  List<Gorevler> gelenListe = [];

  Future<void> projeGorevListele(String gorevProjeId, String token,
      String loginuserid, String userfirmid, String userType) async {
    emit(state.copyWith(
      status: MissionStatus.loading,
      gorevListesi: <Gorevler>[],
    ));
    var liste = await repo.projeGorevListele(
        gorevProjeId, token, loginuserid, userfirmid, userType);
    gelenListe = liste ?? [];
    emit(state.copyWith(
      status: MissionStatus.loaded,
      gorevListesi: gelenListe,
    ));
  }

  Future<void> filterMission(List<Gorevler>? liste, int index) async {
    emit(state.copyWith(
      status: MissionStatus.loading,
      gorevListesi: <Gorevler>[],
    ));
    List<Gorevler> seciliGorevTipiListe = [];
    int missionType = 0;
    if (liste != null) {
      switch (index) {
        case 0:
          seciliGorevTipiListe =
              liste.where((element) => element.gorevUstId == "0").toList();
          break;
        case 1:
          missionType = 1;
          seciliGorevTipiListe =
              liste.where((element) => element.gorevUstId != "0").toList();
          break;
      }
    }
    emit(state.copyWith(
        status: MissionStatus.loaded,
        gorevListesi: seciliGorevTipiListe,
        missionType: missionType));
  }

  Future<void> tumGorevleriListele(
      String token, String loginuserid, int listType) async {
    final liste = await repo.fetchAllMission(token, loginuserid);
    // listType : 0 ana görevler, 1 ek görevler
    await filterMission(liste, listType);
  }

  Future<void> anaGorevEkGorevListele(
      String token, String loginuserid, String gorevUstId) async {
    emit(state.copyWith(
        status: MissionStatus.loading, gorevEkGorevListesi: <Gorevler>[]));
    final liste = await repo.fetchMissionTask(token, loginuserid, gorevUstId);
    emit(state.copyWith(
        status: MissionStatus.loaded, gorevEkGorevListesi: liste));
  }
  // Burada ana görevleri listelerken iki husus mevcut ana görevlerin gorev ust id'leri 0'dır. Ve parametre olarak gelen asamaID ile eşleşenleri yani aşamalar, kendine bağlı ana görevleri listeleyecek.

  List<Gorevler> ilgiliAnaGorevListeGetir(String asamaID) {
    List<Gorevler> gonderilenAnaGorevListe = gelenListe
        .where((veri) => veri.gorevDurum == asamaID && veri.gorevUstId == "0")
        .toList();
    gonderilenAnaGorevListe
        .sort((a, b) => a.gorevSira!.compareTo(b.gorevSira!));
    return gonderilenAnaGorevListe;
  }

  // Burada da gorevUstId gonderilecek bu o gorevın ek görevlerini getirecek.. 0 dışında ki görev id'ler bir görevin alt görevleridir..

  List<Gorevler> ilgiliEkGorevListe(String gorevID) {
    List<Gorevler> gonderilenEkGorevListe =
        gelenListe.where((veri) => veri.gorevUstId == gorevID).toList();
    gonderilenEkGorevListe.sort((a, b) => a.gorevSira!.compareTo(b.gorevSira!));
    return gonderilenEkGorevListe;
  }

  Future<void> ekGorevOnayla(String gorevId, String gorevDurum, String token,
      String loginuserid, String gorevProjeId) async {
    //Ek Gorevin tamamlanıp tamamlanmadığını güncelle 1 gönderilirse tamamlandı, 0 gönderilirse tamamlanmadı.
    //emit(state.copyWith(status: MissionStatus.loading,gorevListesi: <Gorevler>[],));
    await repo.ekGorevOnayla(gorevId, gorevDurum, token, loginuserid);
    //var liste = await repo.projeGorevListele(gorevProjeId, token, loginuserid);
    //emit(state.copyWith(status: MissionStatus.loaded, gorevListesi: liste));
  }

  Future<void> anaGorevEkle(
      String loginuserid,
      String token,
      String kayitliFirma,
      String gorevliler,
      String sorumlular,
      String projeId,
      String gorevAd,
      String gorevAciklama,
      String gorevBaslangicT,
      String gorevBitisT,
      String renkEtiketi,
      String gorevDurum) async {
    await repo.anaGorevEkle(
        loginuserid,
        token,
        kayitliFirma,
        gorevliler,
        sorumlular,
        projeId,
        gorevAd,
        gorevAciklama,
        gorevBaslangicT,
        gorevBitisT,
        renkEtiketi,
        gorevDurum);
  }

  Future<void> anaGorevGuncelle(MissionUpdateModel updateMission) async {
    emit(state.copyWith(status: MissionStatus.loading));
    await repo.anaGorevGuncelle(updateMission);
    final liste = await repo.projeGorevListele(
        updateMission.projeId,
        updateMission.token,
        updateMission.loginuserID,
        updateMission.gorevUserFirmId,
        updateMission.userType);
    gelenListe = liste ?? [];
    emit(state.copyWith(
      status: MissionStatus.loaded,
      gorevListesi: gelenListe,
    ));
  }

  Future<void> ekGorevEkle(AddTaskModel taskModel) async {
    await repo.ekGorevEkle(taskModel);
  }
}
