import 'package:flutter/material.dart';

import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

class CorAWidthButtons extends StatefulWidget {
  final String yazi;
  final IconData icon;
  final Color iconrenk;
  final bool kenarlik;
  final double? yukseklik;
  final void Function()? onPressed;

  const CorAWidthButtons(
      {super.key,
      required this.yazi,
      required this.icon,
      required this.iconrenk,
      required this.kenarlik,
      required this.onPressed,
      this.yukseklik});

  @override
  State<CorAWidthButtons> createState() => _CorAWidthButtonsState();
}

class _CorAWidthButtonsState extends State<CorAWidthButtons> {
  @override
  Widget build(BuildContext context) {
    return Expanded(
      flex: 1,
      child: Material(
        color: Colors.transparent,
        child: InkWell(
          onTap: widget.onPressed,
          splashColor: Colors.grey.shade200,
          borderRadius: BorderRadius.circular(15),
          child: Container(
            height: context.dynamicHeight(
                widget.yukseklik != null ? widget.yukseklik! : 0.091),
            width: context.dynamicWidth(0.258),
            decoration: BoxDecoration(
              color: widget.iconrenk.withOpacity(0.24),
              border: widget.kenarlik
                  ? Border.all(color: Colors.grey.withOpacity(0.3))
                  : Border.all(color: Colors.transparent),
              borderRadius: BorderRadius.circular(15),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                Icon(widget.icon, color: widget.iconrenk),
                Text(
                  widget.yazi,
                  style: const TextStyle(fontSize: 12, color: Colors.black38),
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }
}
