import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:percent_indicator/percent_indicator.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../core/constants/color_constants.dart';

class ProjectContainer extends StatefulWidget {
  final String yazi;
  final Color iconveYazi;
  final double doluluk;

  const ProjectContainer(
      {super.key,
      required this.yazi,
      required this.iconveYazi,
      required this.doluluk});

  @override
  State<ProjectContainer> createState() => _ProjectContainerState();
}

class _ProjectContainerState extends State<ProjectContainer> {
  @override
  Widget build(BuildContext context) {
    double ekranGenisligi = MediaQuery.of(context).size.width;
    return Padding(
      padding: EdgeInsets.only(
          top: context.dynamicHeight(0.018),
          bottom: context.dynamicHeight(0.002)),
      child: Container(
        height: context.dynamicHeight(0.080),
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(5),
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                  color: Colors.grey.withOpacity(0.5),
                  blurRadius: 4,
                  offset: const Offset(1, 1))
            ]),
        child: Row(
          children: [
            Column(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    const SizedBox(width: 8),
                    Icon(
                      Icons.task_alt_outlined,
                      color: widget.iconveYazi,
                      size: context.dynamicWidth(0.042),
                    ),
                    SizedBox(width: context.dynamicWidth(0.035)),
                    Text(widget.yazi),
                  ],
                ),
                SizedBox(
                  height: context.dynamicHeight(0.02),
                  width: context.dynamicWidth(0.50),
                  child: LinearPercentIndicator(
                    lineHeight: 7,
                    percent: widget.doluluk,
                    barRadius: const Radius.circular(15),
                    progressColor: widget.iconveYazi,
                    backgroundColor: ColorsConstants.instance.shadowColor,
                  ),
                ),
              ],
            ),
            const Spacer(),
            SizedBox(
              width: ekranGenisligi / 5,
              child: Stack(
                alignment: Alignment.centerLeft,
                children: [
                  CircleAvatar(
                    radius: 20,
                    backgroundColor: Colors.grey.shade300,
                    child: const CircleAvatar(
                      backgroundColor: Colors.transparent,
                    ),
                  ),
                  Positioned(
                    left: ekranGenisligi / 30,
                    child: CircleAvatar(
                      radius: 22,
                      backgroundColor: Colors.white,
                      child: CircleAvatar(
                        backgroundColor: Colors.grey.shade300,
                      ),
                    ),
                  ),
                ],
              ),
            ),
            IconButton(
              onPressed: () {
                'Proje Seçenekleri...'.log();
              },
              icon: const Icon(
                Icons.more_vert,
                color: Colors.grey,
              ),
            )
          ],
        ),
      ),
    );
  }
}
