import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/constants/app_constants.dart';
import 'package:hamlemuhcrm/core/extensions/int_enum_extension.dart';
import 'package:hamlemuhcrm/features/home/cubit/home_custom_cubit.dart';
import 'package:hamlemuhcrm/features/profile/view/profile_permission.dart';
import 'package:hamlemuhcrm/features/profile/view/profile_view_mixin.dart';
import 'package:percent_indicator/circular_percent_indicator.dart';

import '../../../core/constants/color_constants.dart';
import '../../../core/constants/font_styles.dart';
import '../../../core/constants/url_services_constant.dart';
import '../../../core/extensions/responsive_extension.dart';
import '../../../core/route/page_route.dart';
import '../../auth/login/cubit/login_cubit.dart';
import '../../auth/splash/view/splash_view.dart';
import '../../permissions/view/permission_request_page.dart';
import '../widgets/width_buttons.dart';

class ProfileView extends StatefulWidget {
  const ProfileView({Key? key}) : super(key: key);

  @override
  State<ProfileView> createState() => _ProfileViewState();
}

class _ProfileViewState extends State<ProfileView> with ProfileViewMixin {
  @override
  Widget build(BuildContext context) {
    return isFinish
        ? SingleChildScrollView(
            child: Padding(
              padding:
                  EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.05)),
              child: Column(
                children: [
                  Container(
                    margin: EdgeInsets.only(
                        top: context.dynamicHeight(0.01),
                        bottom: context.dynamicHeight(0.01)),
                    height: context.dynamicHeight(0.34),
                    padding: EdgeInsets.all(context.dynamicHeight(0.008)),
                    decoration: BoxDecoration(
                      boxShadow: [
                        BoxShadow(
                            color: Colors.grey.withOpacity(0.2),
                            offset: const Offset(0.7, 0.4),
                            blurRadius: 8),
                      ],
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(15),
                    ),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                      children: [
                        uploadimage == null
                            ? ClipOval(
                                child: Image.network(
                                  context.read<LoginCubit>().userimage != ''
                                      ? '${URLAPIService.instance.fileBaseURL}/upload-user/${context.read<LoginCubit>().userimage}'
                                      : URLAPIService.instance.defaultPhotoUrl,
                                  cacheHeight: 100,
                                  cacheWidth: 100,
                                ),
                              )
                            : Container(
                                height: context.dynamicHeight(0.15),
                                decoration: BoxDecoration(
                                  shape: BoxShape.circle,
                                  image: DecorationImage(
                                    image: FileImage(uploadimage!),
                                    fit: BoxFit.contain,
                                  ),
                                ),
                              ),
                        SizedBox(
                          height: context.dynamicHeight(0.002),
                        ),
                        Text(
                          "${context.read<LoginCubit>().ad} ${context.read<LoginCubit>().soyad}",
                          style: FontStyles.instance.ortaYazi,
                        ),
                        Text(
                          context.read<LoginCubit>().unvanAd == ''
                              ? 'Ünvan Yok '
                              : context.read<LoginCubit>().unvanAd,
                          style: const TextStyle(
                              color: Colors.black54, fontSize: 13),
                        ),
                        SizedBox(height: context.dynamicHeight(0.002)),
                        Row(
                          children: [
                            //eğer gidilecek sayfa ayrı açılıyorsa bodyIndeksmı false gönder, bodyindeks değiştirilecekse true gönder.
                            const SizedBox(width: 10),
                            Expanded(
                              flex: 1,
                              child: Material(
                                color: Colors.transparent,
                                child: InkWell(
                                  onTap: uploadimage == null
                                      ? () {
                                          chooseImage();
                                        }
                                      : () async {
                                          uploadImage(
                                                  uploadimage!,
                                                  context.read<LoginCubit>().id,
                                                  context.read<LoginCubit>().id,
                                                  context
                                                      .read<LoginCubit>()
                                                      .tip,
                                                  context
                                                      .read<LoginCubit>()
                                                      .userfirmId,
                                                  context
                                                      .read<LoginCubit>()
                                                      .token,
                                                  context
                                                      .read<LoginCubit>()
                                                      .email,
                                                  context
                                                      .read<LoginCubit>()
                                                      .userimage)
                                              .whenComplete(() async {
                                            Navigator.pushReplacement(
                                                context,
                                                MaterialPageRoute(
                                                    builder: (context) =>
                                                        const SplashView()));
                                          });
                                        },
                                  splashColor: Colors.grey.shade200,
                                  borderRadius: BorderRadius.circular(15),
                                  child: Container(
                                    height: context.dynamicHeight(0.084),
                                    width: context.dynamicWidth(0.258),
                                    decoration: BoxDecoration(
                                      color: Colors.blue.withOpacity(0.24),
                                      borderRadius: BorderRadius.circular(15),
                                    ),
                                    child: Column(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceEvenly,
                                      children: [
                                        Icon(
                                            uploadimage == null
                                                ? Icons.photo
                                                : Icons.save,
                                            color: Colors.blue),
                                        Text(
                                          uploadimage == null
                                              ? 'Fotoğraf Değiştir'
                                              : 'Güncelle',
                                          style: const TextStyle(
                                              fontSize: 12,
                                              color: Colors.black38),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ),
                            ),
                            const SizedBox(width: 10),
                            CorAWidthButtons(
                              yazi: 'Profili Düzenle',
                              icon: Icons.save_as,
                              iconrenk: Colors.orange,
                              kenarlik: false,
                              onPressed: () =>
                                  showProfileUpdateBottomSheet(context),
                              yukseklik: 0.084,
                            ),
                            const SizedBox(width: 10),
                            CorAWidthButtons(
                              yazi: 'İzin Al',
                              icon: Icons.account_balance_outlined,
                              iconrenk: Colors.green,
                              onPressed: () {
                                Navigator.push(
                                    context,
                                    CustomPageRoute(
                                        child: PermissionRequestPage(
                                            kalanHak: context
                                                .read<LoginCubit>()
                                                .kalanyillikizinhakkigunsayisi)));
                              },
                              kenarlik: false,
                              yukseklik: 0.084,
                            ),
                            const SizedBox(width: 10),
                          ],
                        ),
                      ],
                    ),
                  ),
                  const SizedBox(height: 15),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Text(ApplicationConstants.instance.employeeInformationTxt,
                          style: FontStyles.instance.ortaYazi),
                    ],
                  ),
                  const SizedBox(height: 15),
                  Container(
                    height: context.dynamicHeight(0.2),
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(15),
                      boxShadow: [
                        BoxShadow(
                            color: Colors.grey.withOpacity(0.2),
                            offset: const Offset(0.7, 0.4),
                            blurRadius: 8),
                      ],
                    ),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                      mainAxisSize: MainAxisSize.max,
                      children: [
                        const SizedBox(width: 7),
                        CircularPercentIndicator(
                          radius: 50,
                          lineWidth: 12,
                          percent: context
                              .watch<HomeCustomCubit>()
                              .gorevSayisi
                              .approximateDivide(
                                  context.watch<HomeCustomCubit>().projeSayisi),
                          center: const CircleAvatar(
                            backgroundColor: Color(0xFFD6D2D1),
                            radius: 25,
                          ),
                          progressColor: ColorsConstants.instance.baseTheme,
                          backgroundColor: Colors.grey.shade100,
                          circularStrokeCap: CircularStrokeCap.round,
                        ),
                        SizedBox(width: context.dynamicWidth(0.02)),
                        Column(
                          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Padding(
                                  padding: EdgeInsets.only(
                                      right: context.dynamicWidth(0.04)),
                                  child: Text(
                                    ApplicationConstants
                                        .instance.projectModuleTxt,
                                    style:
                                        const TextStyle(color: Colors.black54),
                                  ),
                                ),
                                Container(
                                    alignment: Alignment.center,
                                    width: context.dynamicWidth(0.13),
                                    height: context.dynamicHeight(0.03),
                                    decoration: BoxDecoration(
                                        color: ColorsConstants
                                            .instance.baseTheme
                                            .withOpacity(0.2),
                                        borderRadius:
                                            BorderRadius.circular(20)),
                                    child: Text(
                                      '${context.watch<HomeCustomCubit>().projeSayisi}/${context.watch<HomeCustomCubit>().gorevSayisi}',
                                      style: TextStyle(
                                          fontSize: 11,
                                          color: ColorsConstants
                                              .instance.baseTheme
                                              .withOpacity(0.8)),
                                    )),
                              ],
                            ),
                            SizedBox(
                                width: context.dynamicWidth(0.6),
                                child: Text(
                                  'Çalışmış olduğunuz projelerde ki görevlerinize, hızlı bir şekilde aşağıda ki kısayoldan gidebilirsiniz.',
                                  style: Theme.of(context)
                                      .textTheme
                                      .headlineSmall
                                      ?.copyWith(color: Colors.black54),
                                )),
                            TextButton(
                              onPressed: () => context
                                  .read<HomeCustomCubit>()
                                  .setSecilenBodyIndeks(1),
                              style: TextButton.styleFrom(
                                  shape: RoundedRectangleBorder(
                                      borderRadius: BorderRadius.circular(20)),
                                  backgroundColor:
                                      ColorsConstants.instance.baseTheme,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: context.dynamicWidth(0.15))),
                              child: Text(
                                  ApplicationConstants.instance.allMissionTxt,
                                  style: const TextStyle(
                                      color: Colors.white,
                                      fontWeight: FontWeight.w400)),
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                  const SizedBox(height: 20),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Text(ApplicationConstants.instance.allPermissionSendTxt,
                          style: FontStyles.instance.ortaYazi),
                    ],
                  ),
                  const SizedBox(height: 10),
                  const ProfilePermissionList(),
                ],
              ),
            ),
          )
        : const SizedBox();
  }
}
