import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/features/permissions/model/izinler.dart';
import 'package:hamlemuhcrm/data/repo/permissions_repository.dart';

class PermissionCubit extends Cubit<List<Izinler>> {
  PermissionCubit() : super(<Izinler>[]);

  var repo = PermissionRepository();
  List<Izinler> izinlerListele = [];
  List<Izinler> cevapBekleyenler = [];
  List<Izinler> cevaplananIzinler = [];

  Future<void> izinListesi(
      String token, String loginuserid, String userType) async {
    var liste = await repo.izinListele(token, loginuserid);
    // İzin Türlerine Göre Listeleme
    if (userType == "1" || userType == "33") {
      cevapBekleyenler = liste!.where((veri) => veri.izinDurum == '1').toList();
      cevaplananIzinler = liste.where((veri) => veri.izinDurum != '1').toList();
    }
    cevapBekleyenler = liste!
        .where((veri) =>
            veri.izinDurum == '1' && veri.izinOnayUserId == loginuserid)
        .toList();
    cevaplananIzinler = liste
        .where((veri) =>
            veri.izinDurum != '1' && veri.izinOnayUserId == loginuserid)
        .toList();
    emit(liste);
  }

  Future<void> izinTalepEt(
      String kayitliFirmaID,
      String loginuserID,
      String baslangicTarihi,
      String bitisTarihi,
      String izinTip,
      String yerineBakacakPersonelID,
      String onaylayacakUserID,
      String aciklama,
      String token) async {
    await repo.izinTalepEt(
        kayitliFirmaID,
        loginuserID,
        baslangicTarihi,
        bitisTarihi,
        izinTip,
        yerineBakacakPersonelID,
        onaylayacakUserID,
        aciklama,
        token);
  }

  Future<void> izniCevapla(
      String izinId, String izinDurum, String token, String loginuserid) async {
    await repo.izinCevapla(izinId, izinDurum, token, loginuserid);
  }
}
