import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/features/customers/widgets/shimmer_container.dart';

import '../../../core/cubits/notification_cubit.dart';
import '../../../core/widgets/notification_card.dart';

class NotificationView extends StatefulWidget {
  const NotificationView({Key? key}) : super(key: key);
  @override
  State<NotificationView> createState() => _NotificationViewState();
}

class _NotificationViewState extends State<NotificationView> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: BlocBuilder<NotificationCubit, NotificationState>(
        builder: (context, state) {
          if (state.isLoading && !state.isComplete) {
            return const Center(
              child: CircularProgressIndicator(),
            );
          } else if (state.isComplete && !state.isLoading && !state.isError) {
            return column(
              [
                headLine('Okunmamış Bildirimler'),
                heightSpace,
                viewedContainer(ListView.builder(
                    itemCount: state.unViewedNotification.length,
                    itemBuilder: (context, index) => NotificationCard(
                        model: state.unViewedNotification[index]))),
                heightSpace,
                headLine('Okunmuş Bildirimler'),
                heightSpace,
                unviewedContainer(ListView.builder(
                    itemCount: state.viewedNotification.length,
                    itemBuilder: (context, index) => NotificationCard(
                        model: state.viewedNotification[index]))),
                heightSpace,
              ],
            );
          } else {
            return ListView.builder(
                itemCount: state.viewedNotification.length,
                itemBuilder: (context, state) => ShimmerContainer(
                      height: context.dynamicHeight(0.09),
                      color: Colors.red,
                      opacity: 1,
                    ));
          }
        },
      ),
    );
  }

  Widget column(List<Widget> childs) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: childs,
      );
  Widget headLine(String headLine) => Padding(
        padding: pagePaddingSymmetric,
        child: Text(
          headLine,
          style: Theme.of(context).textTheme.titleMedium?.copyWith(
              color: ColorsConstants.instance.selectedDateCalendar,
              fontWeight: FontWeight.bold),
        ),
      );

  Widget get heightSpace => const SizedBox(height: 10);
  Widget viewedContainer(Widget child) => Expanded(
        flex: 3,
        child: child,
      );

  Widget unviewedContainer(Widget child) => Expanded(flex: 3, child: child);

  EdgeInsets get pagePaddingSymmetric =>
      const EdgeInsets.symmetric(horizontal: 15);
}
