import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../../core/constants/color_constants.dart';
import '../../../core/constants/url_services_constant.dart';
import '../../../core/extensions/responsive_extension.dart';
import '../../auth/login/cubit/login_cubit.dart';

import '../model/message.dart';

class MessageBubble extends StatelessWidget {
  final Message message;

  const MessageBubble({Key? key, required this.message}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    bool isSend = message.mesajGonderenId == context.read<LoginCubit>().id;

    bool isStart = message.mesaj == "Görüşme Başladı.";
    bool isRead = true; // Görüldü durumunu kontrol et

    return isStart
        ? Center(child: Text("${message.mesaj} ${message.mesajVerilmetarihi}"))
        : Align(
            alignment: isSend ? Alignment.centerRight : Alignment.centerLeft,
            child: !isSend
                ? Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Expanded(flex: 1, child: _profileImage(context)),
                      Expanded(
                        flex: 4,
                        child: Container(
                          margin: const EdgeInsets.all(8.0),
                          padding: const EdgeInsets.symmetric(
                              horizontal: 10, vertical: 10),
                          decoration: BoxDecoration(
                            color: isSend
                                ? const Color(0xFFE0E0E0)
                                : ColorsConstants.instance.baseTheme,
                            borderRadius: BorderRadius.circular(8.0),
                          ),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                children: [
                                  Text(
                                    message.mesaj ?? "",
                                    style: TextStyle(
                                      color:
                                          isSend ? Colors.black : Colors.white,
                                    ),
                                  ),
                                  //BURADAN DEVAM, KAYMALARI DÜZELT SAATİ DÜZGÜN GÖSTER
                                  Text(
                                    message.mesajVerilmetarihi ??
                                        "".substring(10, 15),
                                    style: TextStyle(
                                      color:
                                          isSend ? Colors.black : Colors.white,
                                    ),
                                  ),
                                ],
                              ),
                              _isView(isRead)
                            ],
                          ),
                        ),
                      )
                    ],
                  )
                : Container(
                    margin: const EdgeInsets.all(8.0),
                    padding: const EdgeInsets.all(12.0),
                    decoration: BoxDecoration(
                      color: isSend
                          ? const Color(0xFFE0E0E0)
                          : ColorsConstants.instance.baseTheme,
                      borderRadius: BorderRadius.circular(8.0),
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.end,
                      children: [
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Text(
                              message.mesaj ?? "",
                              style: TextStyle(
                                color: isSend ? Colors.black : Colors.white,
                              ),
                            ),
                            Text(
                              message.mesajVerilmetarihi ?? "",
                              style: TextStyle(
                                color: isSend ? Colors.black : Colors.white,
                              ),
                            ),
                          ],
                        ),
                        _isView(isRead)
                      ],
                    ),
                  ),
          );
  }

  Widget _profileImage(BuildContext context) => CircleAvatar(
        radius: 30,
        child: CachedNetworkImage(
          height: context.dynamicHeight(0.08),
          fit: BoxFit.fill,
          imageUrl:
              '${URLAPIService.instance.fileBaseURL}/upload-user/${message.mesajAtanFotograf ?? "buresimyok.jpg"}',
          placeholder: (context, url) => CircleAvatar(
            radius: 30,
            backgroundColor: Colors.grey.shade200,
          ),
          imageBuilder: (context, imageProvider) {
            return CircleAvatar(
              radius: 32,
              backgroundColor: Colors.grey,
              child: CircleAvatar(
                radius: 30,
                backgroundImage: imageProvider,
              ),
            );
          },
        ),
      );

  Widget _isView(bool isRead) {
    return switch (isRead) {
      true => const Icon(
          Icons.done_all,
          color: Colors.blue,
          size: 20,
        ),
      false => const Icon(
          Icons.done,
          color: Colors.grey,
          size: 20,
        )
    };
  }

  String breakLongMessage(String message, int breakAfter) {
    StringBuffer result = StringBuffer();
    for (int i = 0; i < message.length; i++) {
      result.write(message[i]);
      if (i != 0 && i % breakAfter == 0) {
        result.write('\n');
      }
    }
    return result.toString();
  }
}
