import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

class ConnectedStatus extends StatelessWidget {
  final bool isConnected;

  const ConnectedStatus({super.key, required this.isConnected});

  @override
  Widget build(BuildContext context) {
    const String connectionStatusTxt = "Bağlantı ";
    final theme = Theme.of(context);
    return Padding(
      padding: _allPadding,
      child: Container(
        height: context.dynamicHeight(0.05),
        decoration: BoxDecoration(
          color:
              ColorsConstants.instance.containerBorderGreyColor.withOpacity(.3),
          borderRadius: BorderRadius.circular(10),
          border:
              Border.all(color: ColorsConstants.instance.selectedDateCalendar),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Text(
              connectionStatusTxt,
              style: theme.textTheme.bodyMedium?.copyWith(
                  color:
                      ColorsConstants.instance.navigationMeetButtonGreyColor),
            ),
            _icon
          ],
        ),
      ),
    );
  }

  Widget get _icon => Icon(
        Icons.circle,
        color: isConnected
            ? ColorsConstants.instance.appGreen
            : ColorsConstants.instance.appBlue,
      );

  EdgeInsets get _allPadding =>
      const EdgeInsets.all(kFloatingActionButtonMargin);
}
